/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.zookeeper.coordination;

import co.cask.cdap.common.zookeeper.coordination.BalancedAssignmentStrategy;
import co.cask.cdap.common.zookeeper.coordination.DefaultResourceAssigner;
import co.cask.cdap.common.zookeeper.coordination.PartitionReplica;
import co.cask.cdap.common.zookeeper.coordination.ResourceAssigner;
import co.cask.cdap.common.zookeeper.coordination.ResourceRequirement;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class AssignmentStrategyTest {
    @Test
    public void testBalance() {
        ResourceRequirement requirement = ResourceRequirement.builder((String)"resource").addPartitions("p", 2, 2).build();
        ResourceAssigner assigner = DefaultResourceAssigner.create((Multimap)HashMultimap.create());
        BalancedAssignmentStrategy strategy = new BalancedAssignmentStrategy();
        ImmutableSet handlers = ImmutableSet.of((Object)"h1");
        strategy.assign(requirement, (Set)handlers, assigner);
        Multimap assignments = assigner.get();
        Assert.assertEquals((long)4L, (long)assignments.get((Object)"h1").size());
        handlers = ImmutableSet.of((Object)"h1", (Object)"h2", (Object)"h3", (Object)"h4", (Object)"h5");
        strategy.assign(requirement, (Set)handlers, assigner);
        Map result = Maps.filterValues((Map)assigner.get().asMap(), (Predicate)new Predicate<Collection<PartitionReplica>>(){

            public boolean apply(Collection<PartitionReplica> input) {
                return input.size() == 1;
            }
        });
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("h1"));
        ImmutableSet handlerOneAssignment = ImmutableSet.copyOf((Collection)((Collection)result.get("h1")));
        requirement = ResourceRequirement.builder((String)"resource").addPartitions("p", 10, 2).build();
        strategy.assign(requirement, (Set)handlers, assigner);
        for (Map.Entry entry : assigner.get().asMap().entrySet()) {
            Assert.assertEquals((long)4L, (long)((Collection)entry.getValue()).size());
        }
        Assert.assertEquals((long)20L, (long)ImmutableSet.copyOf((Collection)assigner.get().values()).size());
        Assert.assertTrue((boolean)Sets.difference((Set)handlerOneAssignment, (Set)ImmutableSet.copyOf((Collection)assigner.get().get((Object)"h1"))).isEmpty());
        requirement = ResourceRequirement.builder((String)"resource").addPartitions("p", 6, 2).build();
        Multimap oldAssignments = assigner.get();
        assignments = HashMultimap.create((Multimap)oldAssignments);
        Iterator iterator = assignments.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (Integer.parseInt(((PartitionReplica)entry.getValue()).getName().substring(1)) < 6) continue;
            iterator.remove();
        }
        handlers = ImmutableSet.of((Object)"h1", (Object)"h2", (Object)"h3", (Object)"h4", (Object)"h5", (Object)"h6", (Object[])new String[]{"h7"});
        assigner = DefaultResourceAssigner.create((Multimap)assignments);
        strategy.assign(requirement, (Set)handlers, assigner);
        for (Map.Entry entry : assigner.get().asMap().entrySet()) {
            Collection oldAssignment = oldAssignments.get(entry.getKey());
            if (oldAssignment.isEmpty()) continue;
            Assert.assertTrue((boolean)Sets.difference((Set)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), (Set)ImmutableSet.copyOf((Collection)oldAssignment)).isEmpty());
        }
    }
}

