/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.test;

import co.cask.cdap.common.lang.ClassLoaders;
import co.cask.cdap.common.test.TestRunner;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TestSuite
extends ParentRunner<Runner> {
    private final List<Runner> runners;

    private static Class<?>[] getAnnotatedClasses(Class<?> suiteClass) throws InitializationError {
        Suite.SuiteClasses annotation = suiteClass.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", suiteClass.getName()));
        }
        return annotation.value();
    }

    public TestSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        this(builder, suiteClass, TestSuite.getAnnotatedClasses(suiteClass));
    }

    private TestSuite(RunnerBuilder builder, Class<?> suiteClass, Class<?>[] runnerClasses) throws InitializationError {
        super(TestSuite.createClass(suiteClass));
        this.runners = builder.runners(TestSuite.createClass(suiteClass), (Class[])runnerClasses);
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        runner.run(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        ClassLoader cl = ClassLoaders.setContextClassLoader((ClassLoader)this.getTestClass().getJavaClass().getClassLoader());
        try {
            super.run(notifier);
        }
        finally {
            ClassLoaders.setContextClassLoader((ClassLoader)cl);
        }
    }

    private static Class<?> createClass(Class<?> suiteClass) throws InitializationError {
        try {
            return TestRunner.TEST_CLASSLOADER.loadClass(suiteClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
    }
}

