/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.test;

import co.cask.cdap.common.app.MainClassLoader;
import co.cask.cdap.common.lang.ClassLoaders;
import co.cask.cdap.common.lang.FilterClassLoader;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunner.class);
    static final ClassLoader TEST_CLASSLOADER;

    public TestRunner(Class<?> testClass) throws InitializationError {
        super(TestRunner.createClass(testClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        ClassLoader cl = ClassLoaders.setContextClassLoader((ClassLoader)this.getTestClass().getJavaClass().getClassLoader());
        try {
            super.run(notifier);
        }
        finally {
            ClassLoaders.setContextClassLoader((ClassLoader)cl);
        }
    }

    private static Class<?> createClass(Class<?> testClass) throws InitializationError {
        try {
            return TEST_CLASSLOADER.loadClass(testClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    static {
        Object classLoader = MainClassLoader.createFromContext((FilterClassLoader.Filter)new FilterClassLoader.Filter(){

            public boolean acceptResource(String resource) {
                return resource.startsWith("org/junit/") || resource.startsWith("org/hamcrest/");
            }

            public boolean acceptPackage(String packageName) {
                return packageName.equals("org.junit") || packageName.startsWith("org.junit.") || packageName.equals("org.hamcrest") || packageName.startsWith("org.hamcrest.");
            }
        });
        if (classLoader == null) {
            LOG.warn("Unabled to create MainClassLoader for class rewrite in unit-test. Fallback to default ClassLoader.");
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
        }
        TEST_CLASSLOADER = classLoader;
    }
}

