/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.test;

import co.cask.cdap.common.lang.ClassLoaders;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.internal.ApplicationBundler;

public final class PluginJarHelper {
    private PluginJarHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Location createPluginJar(LocationFactory locationFactory, Manifest manifest, Class<?> clz, Class<?> ... classes) throws IOException {
        HashSet<String> includePackages = new HashSet<String>();
        includePackages.add("org.apache.hadoop.hbase");
        includePackages.add(clz.getPackage().getName());
        for (Class<?> clazz : classes) {
            includePackages.add(clazz.getPackage().getName());
        }
        ApplicationBundler bundler = new ApplicationBundler((Iterable)ImmutableList.of((Object)"co.cask.cdap.api", (Object)"org.apache.hadoop", (Object)"org.apache.hive", (Object)"org.apache.spark"), includePackages);
        Location jarLocation = locationFactory.create(clz.getName()).getTempFile(".jar");
        ClassLoader oldClassLoader = ClassLoaders.setContextClassLoader((ClassLoader)clz.getClassLoader());
        try {
            bundler.createBundle(jarLocation, clz, (Class[])classes);
        }
        finally {
            ClassLoaders.setContextClassLoader((ClassLoader)oldClassLoader);
        }
        Location deployJar = locationFactory.create(clz.getName()).getTempFile(".jar");
        Manifest jarManifest = new Manifest(manifest);
        jarManifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try (JarOutputStream jarOutput = new JarOutputStream(deployJar.getOutputStream(), jarManifest);
             JarInputStream jarInput = new JarInputStream(jarLocation.getInputStream());){
            JarEntry jarEntry = jarInput.getNextJarEntry();
            while (jarEntry != null) {
                boolean isDir = jarEntry.isDirectory();
                String entryName = jarEntry.getName();
                if (!entryName.equals("classes/")) {
                    jarEntry = entryName.startsWith("classes/") ? new JarEntry(entryName.substring("classes/".length())) : new JarEntry(entryName);
                    if ("META-INF/MANIFEST.MF".equalsIgnoreCase(jarEntry.getName())) {
                        jarEntry = jarInput.getNextJarEntry();
                        continue;
                    }
                    jarOutput.putNextEntry(jarEntry);
                    if (!isDir) {
                        ByteStreams.copy((InputStream)jarInput, (OutputStream)jarOutput);
                    }
                }
                jarEntry = jarInput.getNextJarEntry();
            }
        }
        return deployJar;
    }
}

