/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.test;

import co.cask.cdap.common.lang.ClassLoaders;
import co.cask.cdap.common.lang.ProgramResources;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.twill.api.ClassAcceptor;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.internal.ApplicationBundler;

public final class AppJarHelper {
    private AppJarHelper() {
    }

    public static Location createDeploymentJar(LocationFactory locationFactory, Class<?> clz, Manifest manifest, File ... bundleEmbeddedJars) throws IOException {
        return AppJarHelper.createDeploymentJar(locationFactory, clz, manifest, new ClassAcceptor(){
            final Set<String> visibleResources = ProgramResources.getVisibleResources();

            public boolean accept(String className, URL classUrl, URL classPathUrl) {
                if (this.visibleResources.contains(className.replace('.', '/') + ".class")) {
                    return false;
                }
                return !className.startsWith("org.apache.spark.");
            }
        }, bundleEmbeddedJars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Location createDeploymentJar(LocationFactory locationFactory, Class<?> clz, Manifest manifest, ClassAcceptor classAcceptor, File ... bundleEmbeddedJars) throws IOException {
        ApplicationBundler bundler = new ApplicationBundler(classAcceptor);
        Location jarLocation = locationFactory.create(clz.getName()).getTempFile(".jar");
        ClassLoader oldClassLoader = ClassLoaders.setContextClassLoader((ClassLoader)clz.getClassLoader());
        try {
            bundler.createBundle(jarLocation, clz, new Class[0]);
        }
        finally {
            ClassLoaders.setContextClassLoader((ClassLoader)oldClassLoader);
        }
        Location deployJar = locationFactory.create(clz.getName()).getTempFile(".jar");
        Manifest jarManifest = new Manifest(manifest);
        jarManifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        jarManifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, clz.getName());
        HashSet<String> seenEntries = new HashSet<String>();
        try (JarOutputStream jarOutput = new JarOutputStream(deployJar.getOutputStream(), jarManifest);
             JarInputStream jarInput = new JarInputStream(jarLocation.getInputStream());){
            JarEntry jarEntry = jarInput.getNextJarEntry();
            while (jarEntry != null) {
                boolean isDir = jarEntry.isDirectory();
                String entryName = jarEntry.getName();
                if (!entryName.equals("classes/")) {
                    jarEntry = entryName.startsWith("classes/") ? new JarEntry(entryName.substring("classes/".length())) : new JarEntry(entryName);
                    if ("META-INF/MANIFEST.MF".equalsIgnoreCase(jarEntry.getName())) {
                        jarEntry = jarInput.getNextJarEntry();
                        continue;
                    }
                    if (seenEntries.add(jarEntry.getName())) {
                        jarOutput.putNextEntry(jarEntry);
                        if (!isDir) {
                            ByteStreams.copy((InputStream)jarInput, (OutputStream)jarOutput);
                        }
                    }
                }
                jarEntry = jarInput.getNextJarEntry();
            }
            for (File embeddedJar : bundleEmbeddedJars) {
                jarEntry = new JarEntry("lib/" + embeddedJar.getName());
                if (!seenEntries.add(jarEntry.getName())) continue;
                jarOutput.putNextEntry(jarEntry);
                Files.copy((File)embeddedJar, (OutputStream)jarOutput);
            }
        }
        return deployJar;
    }

    public static Location createDeploymentJar(LocationFactory locationFactory, Class<?> clz, File ... bundleEmbeddedJars) throws IOException {
        Manifest manifest = new Manifest();
        return AppJarHelper.createDeploymentJar(locationFactory, clz, manifest, bundleEmbeddedJars);
    }
}

