/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.startup;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.guice.ConfigModule;
import co.cask.cdap.common.startup.CheckRunner;
import co.cask.cdap.common.startup.check.NoOpCheck;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CheckRunnerTest {
    private static final String FAILURE_MESSAGE = "test failure message";
    private static Injector injector;

    @BeforeClass
    public static void setupTests() {
        CConfiguration cConf = CConfiguration.create();
        cConf.set("cdap.test.check.failure.key", FAILURE_MESSAGE);
        injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(cConf)});
    }

    @Test(expected=ClassNotFoundException.class)
    public void testNonexistentClassThrowsException() throws Exception {
        CheckRunner.builder((Injector)injector).addClass("asdf").build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonCheckClassThrowsException() throws Exception {
        CheckRunner.builder((Injector)injector).addClass(this.getClass().getName());
    }

    @Test
    public void testMultipleChecks() throws Exception {
        CheckRunner checkRunner = CheckRunner.builder((Injector)injector).addChecksInPackage(NoOpCheck.class.getPackage().getName()).build();
        List failures = checkRunner.runChecks();
        Assert.assertEquals((long)1L, (long)failures.size());
        Assert.assertEquals((Object)"failure", (Object)((CheckRunner.Failure)failures.get(0)).getName());
        Assert.assertEquals((Object)FAILURE_MESSAGE, (Object)((CheckRunner.Failure)failures.get(0)).getException().getMessage());
    }

    @Test
    public void testSingleCheck() throws Exception {
        CheckRunner checkRunner = CheckRunner.builder((Injector)injector).addClass(NoOpCheck.class.getName()).build();
        List failures = checkRunner.runChecks();
        Assert.assertTrue((boolean)failures.isEmpty());
    }
}

