/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.security;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.io.Locations;
import co.cask.cdap.common.security.DefaultUGIProvider;
import co.cask.cdap.common.security.ImpersonationInfo;
import co.cask.cdap.common.security.RemoteUGIProvider;
import co.cask.http.AbstractHttpHandler;
import co.cask.http.HttpResponder;
import co.cask.http.NettyHttpService;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.gson.Gson;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.InMemoryDiscoveryService;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UGIProviderTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private static CConfiguration cConf;
    private static MiniDFSCluster miniDFSCluster;
    private static LocationFactory locationFactory;
    private static MiniKdc miniKdc;
    private static File keytabFile;

    @BeforeClass
    public static void init() throws Exception {
        cConf = CConfiguration.create();
        cConf.set("local.data.dir", TEMP_FOLDER.newFolder().getAbsolutePath());
        miniKdc = new MiniKdc(MiniKdc.createConf(), TEMP_FOLDER.newFolder());
        miniKdc.start();
        System.setProperty("java.security.krb5.conf", miniKdc.getKrb5conf().getAbsolutePath());
        keytabFile = TEMP_FOLDER.newFile();
        miniKdc.createPrincipal(keytabFile, new String[]{"hdfs", "alice", "bob"});
        Configuration hConf = new Configuration();
        hConf.set("hdfs.minidfs.basedir", TEMP_FOLDER.newFolder().getAbsolutePath());
        miniDFSCluster = new MiniDFSCluster.Builder(hConf).numDataNodes(1).build();
        miniDFSCluster.waitClusterUp();
        locationFactory = new FileContextLocationFactory(miniDFSCluster.getFileSystem().getConf());
        hConf = new Configuration();
        hConf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)hConf);
    }

    @AfterClass
    public static void finish() {
        if (miniDFSCluster != null) {
            miniDFSCluster.shutdown();
        }
        if (miniKdc != null) {
            miniKdc.stop();
        }
    }

    @Test
    public void testDefaultUGIProvider() throws IOException {
        System.setProperty("sun.security.krb5.debug", "true");
        DefaultUGIProvider provider = new DefaultUGIProvider(cConf, locationFactory);
        ImpersonationInfo aliceInfo = new ImpersonationInfo(UGIProviderTest.getPrincipal("alice"), keytabFile.getAbsolutePath());
        UserGroupInformation aliceUGI = provider.getConfiguredUGI(aliceInfo);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)aliceUGI.getAuthenticationMethod());
        Assert.assertTrue((boolean)aliceUGI.hasKerberosCredentials());
        Assert.assertSame((Object)aliceUGI, (Object)provider.getConfiguredUGI(aliceInfo));
        Location remoteKeytab = locationFactory.create("keytab").getTempFile(".tmp");
        Files.copy((File)keytabFile, (OutputSupplier)Locations.newOutputSupplier((Location)remoteKeytab));
        ImpersonationInfo bobInfo = new ImpersonationInfo(UGIProviderTest.getPrincipal("bob"), remoteKeytab.toURI().toString());
        UserGroupInformation bobUGI = provider.getConfiguredUGI(bobInfo);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)bobUGI.getAuthenticationMethod());
        Assert.assertTrue((boolean)bobUGI.hasKerberosCredentials());
        remoteKeytab.delete();
        Assert.assertSame((Object)bobUGI, (Object)provider.getConfiguredUGI(bobInfo));
        provider.invalidCache();
        Assert.assertNotSame((Object)aliceUGI, (Object)provider.getConfiguredUGI(aliceInfo));
        try {
            provider.getConfiguredUGI(bobInfo);
            Assert.fail((String)("Expected IOException when getting UGI for " + bobInfo));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteUGIProvider() throws Exception {
        NettyHttpService httpService = NettyHttpService.builder((String)"remoteUGITest").addHttpHandlers(Collections.singleton(new UGIProviderTestHandler())).build();
        httpService.startAndWait();
        try {
            InMemoryDiscoveryService discoveryService = new InMemoryDiscoveryService();
            discoveryService.register(new Discoverable("appfabric", httpService.getBindAddress()));
            RemoteUGIProvider ugiProvider = new RemoteUGIProvider(cConf, (DiscoveryServiceClient)discoveryService, locationFactory);
            ImpersonationInfo aliceInfo = new ImpersonationInfo(UGIProviderTest.getPrincipal("alice"), keytabFile.toURI().toString());
            UserGroupInformation aliceUGI = ugiProvider.getConfiguredUGI(aliceInfo);
            Assert.assertFalse((boolean)aliceUGI.hasKerberosCredentials());
            Token token = aliceUGI.getCredentials().getToken(new Text("principal"));
            Assert.assertArrayEquals((byte[])aliceInfo.getPrincipal().getBytes(StandardCharsets.UTF_8), (byte[])token.getIdentifier());
            Assert.assertArrayEquals((byte[])aliceInfo.getPrincipal().getBytes(StandardCharsets.UTF_8), (byte[])token.getPassword());
            Assert.assertEquals((Object)new Text("principal"), (Object)token.getKind());
            Assert.assertEquals((Object)new Text("service"), (Object)token.getService());
            token = aliceUGI.getCredentials().getToken(new Text("keytab"));
            Assert.assertArrayEquals((byte[])aliceInfo.getKeytabURI().getBytes(StandardCharsets.UTF_8), (byte[])token.getIdentifier());
            Assert.assertArrayEquals((byte[])aliceInfo.getKeytabURI().getBytes(StandardCharsets.UTF_8), (byte[])token.getPassword());
            Assert.assertEquals((Object)new Text("keytab"), (Object)token.getKind());
            Assert.assertEquals((Object)new Text("service"), (Object)token.getService());
            Assert.assertSame((Object)aliceUGI, (Object)ugiProvider.getConfiguredUGI(aliceInfo));
            ugiProvider.invalidCache();
            Assert.assertNotSame((Object)aliceUGI, (Object)ugiProvider.getConfiguredUGI(aliceInfo));
        }
        finally {
            httpService.stopAndWait();
        }
    }

    private static String getPrincipal(String name) {
        return String.format("%s@%s", name, miniKdc.getRealm());
    }

    public static final class UGIProviderTestHandler
    extends AbstractHttpHandler {
        @Path(value="/v1/impersonation/credentials")
        @POST
        public void getCredentials(HttpRequest request, HttpResponder responder) throws IOException {
            ImpersonationInfo impersonationInfo = (ImpersonationInfo)new Gson().fromJson(request.getContent().toString(StandardCharsets.UTF_8), ImpersonationInfo.class);
            Credentials credentials = new Credentials();
            credentials.addToken(new Text("principal"), new Token(impersonationInfo.getPrincipal().getBytes(StandardCharsets.UTF_8), impersonationInfo.getPrincipal().getBytes(StandardCharsets.UTF_8), new Text("principal"), new Text("service")));
            credentials.addToken(new Text("keytab"), new Token(impersonationInfo.getKeytabURI().getBytes(StandardCharsets.UTF_8), impersonationInfo.getKeytabURI().getBytes(StandardCharsets.UTF_8), new Text("keytab"), new Text("service")));
            Location credentialsDir = locationFactory.create("credentials");
            Preconditions.checkState((boolean)credentialsDir.mkdirs());
            Location credentialsFile = credentialsDir.append("tmp").getTempFile(".credentials");
            try (DataOutputStream os = new DataOutputStream(new BufferedOutputStream(credentialsFile.getOutputStream()));){
                credentials.writeTokenStorageToStream(os);
            }
            responder.sendString(HttpResponseStatus.OK, credentialsFile.toURI().toString());
        }
    }
}

