/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.namespace;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.namespace.NamespacedLocationFactory;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.NamespaceMeta;
import com.google.inject.Inject;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;

public class NamespacedLocationFactoryTestClient
implements NamespacedLocationFactory {
    private final LocationFactory locationFactory;
    private final String namespaceDir;

    @Inject
    public NamespacedLocationFactoryTestClient(CConfiguration cConf, LocationFactory locationFactory) {
        this.namespaceDir = cConf.get("namespaces.dir");
        this.locationFactory = locationFactory;
    }

    public Location get(Id.Namespace namespaceId) throws IOException {
        return this.get(namespaceId, null);
    }

    public Location get(NamespaceMeta namespaceMeta) throws IOException {
        return this.get(namespaceMeta.getNamespaceId().toId(), null);
    }

    public Location get(Id.Namespace namespaceId, @Nullable String subPath) throws IOException {
        Location namespaceLocation = this.locationFactory.create(this.namespaceDir).append(namespaceId.getId());
        if (subPath != null) {
            namespaceLocation = namespaceLocation.append(subPath);
        }
        return namespaceLocation;
    }

    public Location getBaseLocation() throws IOException {
        return this.locationFactory.create("/");
    }
}

