/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.namespace;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.io.RootLocationFactory;
import co.cask.cdap.common.namespace.DefaultNamespacedLocationFactory;
import co.cask.cdap.common.namespace.InMemoryNamespaceClient;
import co.cask.cdap.common.namespace.NamespaceQueryAdmin;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.NamespaceMeta;
import co.cask.cdap.proto.id.NamespaceId;
import java.io.File;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DefaultNamespacedLocationFactoryTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();

    @Test
    public void testGet() throws Exception {
        File rootLocationFactoryPath = TEMP_FOLDER.newFolder();
        RootLocationFactory rootLocationFactory = new RootLocationFactory((LocationFactory)new LocalLocationFactory(rootLocationFactoryPath));
        File locationFactoryPath = TEMP_FOLDER.newFolder();
        LocalLocationFactory locationFactory = new LocalLocationFactory(locationFactoryPath);
        InMemoryNamespaceClient nsAdmin = new InMemoryNamespaceClient();
        Id.Namespace ns1 = Id.Namespace.from((String)"ns1");
        NamespaceMeta defaultNSMeta = new NamespaceMeta.Builder().setName(Id.Namespace.DEFAULT).build();
        NamespaceMeta ns1NSMeta = new NamespaceMeta.Builder().setName(ns1).setRootDirectory("/ns1").build();
        nsAdmin.create(defaultNSMeta);
        nsAdmin.create(ns1NSMeta);
        CConfiguration cConf = CConfiguration.create();
        DefaultNamespacedLocationFactory namespacedLocationFactory = new DefaultNamespacedLocationFactory(cConf, rootLocationFactory, (LocationFactory)locationFactory, (NamespaceQueryAdmin)nsAdmin);
        Location defaultLoc = namespacedLocationFactory.get(Id.Namespace.DEFAULT);
        Location ns1Loc = namespacedLocationFactory.get(ns1);
        Location expectedLocation = locationFactory.create(cConf.get("namespaces.dir")).append(NamespaceId.DEFAULT.getNamespace());
        Assert.assertEquals((Object)expectedLocation, (Object)defaultLoc);
        expectedLocation = rootLocationFactory.create("/ns1");
        Assert.assertEquals((Object)expectedLocation, (Object)ns1Loc);
        Assert.assertNotEquals((Object)defaultLoc, (Object)ns1Loc);
        Location sub1 = namespacedLocationFactory.get(ns1, "sub1");
        Location sub2 = namespacedLocationFactory.get(ns1, "sub2");
        Assert.assertNotEquals((Object)sub1, (Object)sub2);
    }
}

