/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.lang;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.annotation.Property;
import co.cask.cdap.api.app.Application;
import co.cask.cdap.api.app.ApplicationConfigurer;
import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.common.io.Locations;
import co.cask.cdap.common.lang.ClassLoaders;
import co.cask.cdap.common.lang.CombineClassLoader;
import co.cask.cdap.common.lang.Delegators;
import co.cask.cdap.common.lang.DirectoryClassLoader;
import co.cask.cdap.common.lang.InterceptableClassLoader;
import co.cask.cdap.common.lang.PackageFilterClassLoader;
import co.cask.cdap.common.lang.WeakReferenceDelegatorClassLoader;
import co.cask.cdap.common.lang.jar.BundleJarUtil;
import co.cask.cdap.common.test.AppJarHelper;
import co.cask.cdap.internal.io.SchemaGenerator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.twill.api.ClassAcceptor;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.internal.ApplicationBundler;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ClassLoaderTest {
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();

    @Test
    public void testPackageFilter() throws ClassNotFoundException {
        PackageFilterClassLoader classLoader = new PackageFilterClassLoader(this.getClass().getClassLoader(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith("co.cask.cdap.api.");
            }
        });
        Class<?> cls = classLoader.loadClass(Application.class.getName());
        Assert.assertSame(Application.class, cls);
        try {
            classLoader.loadClass(SchemaGenerator.class.getName());
            Assert.fail();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        Assert.assertNotNull((Object)classLoader.getResource("logback-test.xml"));
        String resourceName = Application.class.getName().replace('.', '/') + ".class";
        URL url = classLoader.getResource(resourceName);
        Assert.assertNotNull((Object)url);
        Assert.assertEquals((Object)this.getClass().getClassLoader().getResource(resourceName), (Object)url);
        resourceName = SchemaGenerator.class.getName().replace('.', '/') + ".class";
        Assert.assertNull((Object)classLoader.getResource(resourceName));
    }

    @Test
    public void testCombineClassLoader() throws ClassNotFoundException {
        ClassLoader parent = this.getClass().getClassLoader();
        CombineClassLoader classLoader = new CombineClassLoader(null, (Iterable)ImmutableList.of((Object)new PackageFilterClassLoader(parent, Predicates.equalTo((Object)Application.class.getPackage().getName())), (Object)new PackageFilterClassLoader(parent, Predicates.equalTo((Object)Beta.class.getPackage().getName()))));
        Assert.assertSame(ApplicationConfigurer.class, classLoader.loadClass(ApplicationConfigurer.class.getName()));
        Assert.assertSame(Property.class, classLoader.loadClass(Property.class.getName()));
        try {
            classLoader.loadClass(Bytes.class.getName());
            Assert.fail();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testWeakReferenceClassLoader() throws Exception {
        Location jar = AppJarHelper.createDeploymentJar((LocationFactory)new LocalLocationFactory(TMP_FOLDER.newFolder()), ClassLoaderTest.class, new File[0]);
        File unpackDir = TMP_FOLDER.newFolder();
        BundleJarUtil.unJar((Location)jar, (File)unpackDir);
        DirectoryClassLoader cl = new DirectoryClassLoader(unpackDir, null, new String[]{"lib"});
        WeakReferenceDelegatorClassLoader classLoader = new WeakReferenceDelegatorClassLoader((ClassLoader)cl);
        Class<?> cls = classLoader.loadClass(ClassLoaderTest.class.getName());
        Assert.assertSame((Object)cl, (Object)cls.getClassLoader());
        Assert.assertSame((Object)cl, (Object)Delegators.getDelegate((Object)classLoader, ClassLoader.class));
    }

    @Test
    public void testExtraClassPath() throws IOException, ClassNotFoundException {
        File tmpDir = TMP_FOLDER.newFolder();
        ApplicationBundler bundler = new ApplicationBundler(new ClassAcceptor());
        Location guavaJar = Locations.toLocation((File)new File(tmpDir, "guava.jar"));
        bundler.createBundle(guavaJar, ImmutableList.class, new Class[0]);
        Location gsonJar = Locations.toLocation((File)new File(tmpDir, "gson.jar"));
        bundler.createBundle(gsonJar, Gson.class, new Class[0]);
        File guavaDir = BundleJarUtil.unJar((Location)guavaJar, (File)TMP_FOLDER.newFolder());
        File gsonDir = BundleJarUtil.unJar((Location)gsonJar, (File)TMP_FOLDER.newFolder());
        String extraClassPath = gsonDir.getAbsolutePath() + File.pathSeparatorChar + gsonDir.getAbsolutePath() + "/lib/*";
        DirectoryClassLoader cl = new DirectoryClassLoader(guavaDir, extraClassPath, null, Arrays.asList("lib"));
        cl.loadClass(ImmutableList.class.getName());
        cl.loadClass(Gson.class.getName());
    }

    @Test
    public void testDefinePackage() throws ClassNotFoundException {
        List urls = (List)ClassLoaders.getClassLoaderURLs((ClassLoader)this.getClass().getClassLoader(), new ArrayList());
        InterceptableClassLoader cl = new InterceptableClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader().getParent()){

            protected boolean needIntercept(String className) {
                return ClassLoaderTest.class.getName().equals(className) || className.startsWith("com.google.common.");
            }

            public byte[] rewriteClass(String className, InputStream input) throws IOException {
                return ByteStreams.toByteArray((InputStream)input);
            }
        };
        Class<?> cls = cl.loadClass(Application.class.getName());
        Assert.assertSame((Object)cl, (Object)cls.getClassLoader());
        Assert.assertEquals((Object)Application.class.getPackage().getName(), (Object)cls.getPackage().getName());
        cls = cl.loadClass(ClassLoaderTest.class.getName());
        Assert.assertSame((Object)cl, (Object)cls.getClassLoader());
        Assert.assertEquals((Object)ClassLoaderTest.class.getPackage().getName(), (Object)cls.getPackage().getName());
        cls = cl.loadClass(Function.class.getName());
        Assert.assertSame((Object)cl, (Object)cls.getClassLoader());
        Package functionPackage = cls.getPackage();
        Assert.assertEquals((Object)Function.class.getPackage().getName(), (Object)functionPackage.getName());
        cls = cl.loadClass(Supplier.class.getName());
        Assert.assertSame((Object)cl, (Object)cls.getClassLoader());
        Assert.assertSame((Object)functionPackage, (Object)cls.getPackage());
    }
}

