/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import co.cask.cdap.api.artifact.ArtifactVersion;
import co.cask.cdap.api.plugin.PluginClass;
import co.cask.cdap.api.plugin.PluginPropertyField;
import co.cask.cdap.common.InvalidArtifactException;
import co.cask.cdap.common.conf.ArtifactConfig;
import co.cask.cdap.common.conf.ArtifactConfigReader;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.artifact.ArtifactRange;
import co.cask.cdap.proto.id.NamespaceId;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ArtifactConfigReaderTest {
    private static final ArtifactConfigReader configReader = new ArtifactConfigReader();
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testRead() throws IOException, InvalidArtifactException {
        ArtifactConfig validConfig = new ArtifactConfig((Set)ImmutableSet.of((Object)new ArtifactRange(NamespaceId.SYSTEM, "a", new ArtifactVersion("1.0.0"), new ArtifactVersion("2.0.0")), (Object)new ArtifactRange(NamespaceId.DEFAULT, "b", new ArtifactVersion("1.0.0"), new ArtifactVersion("2.0.0"))), (Set)ImmutableSet.of((Object)new PluginClass("type", "name", "desc", "classname", null, (Map)ImmutableMap.of((Object)"x", (Object)new PluginPropertyField("x", "some field", "int", true, false), (Object)"y", (Object)new PluginPropertyField("y", "some other field", "string", false, false)))), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2"));
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write(validConfig.toString());
        }
        Assert.assertEquals((Object)validConfig, (Object)configReader.read(Id.Namespace.DEFAULT, configFile));
    }

    @Test(expected=InvalidArtifactException.class)
    public void testInvalidParentNamespace() throws IOException, InvalidArtifactException {
        ArtifactConfig badConfig = new ArtifactConfig((Set)ImmutableSet.of((Object)new ArtifactRange(NamespaceId.DEFAULT, "b", new ArtifactVersion("1.0.0"), new ArtifactVersion("2.0.0"))), (Set)ImmutableSet.of(), (Map)ImmutableMap.of());
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write(badConfig.toString());
        }
        configReader.read(Id.Namespace.SYSTEM, configFile);
    }

    @Test(expected=InvalidArtifactException.class)
    public void testBadJsonSyntax() throws IOException, InvalidArtifactException {
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write("I am invalid.");
        }
        configReader.read(Id.Namespace.SYSTEM, configFile);
    }

    @Test(expected=InvalidArtifactException.class)
    public void testMissingPluginFields() throws IOException, InvalidArtifactException {
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write("{ \"plugins\": [ { \"name\": \"something\" } ] }");
        }
        configReader.read(Id.Namespace.SYSTEM, configFile);
    }

    @Test(expected=InvalidArtifactException.class)
    public void testMalformedParentArtifact() throws IOException, InvalidArtifactException {
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write("{ \"parents\": [ \"r2:[1.0.0,2.0.0) \" ] }");
        }
        configReader.read(Id.Namespace.SYSTEM, configFile);
    }

    @Test(expected=InvalidArtifactException.class)
    public void testBadParentArtifactName() throws IOException, InvalidArtifactException {
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write("{ \"parents\": [ \"r!2[1.0.0,2.0.0) \" ] }");
        }
        configReader.read(Id.Namespace.SYSTEM, configFile);
    }

    @Test(expected=InvalidArtifactException.class)
    public void testBadParentArtifactRange() throws IOException, InvalidArtifactException {
        File configFile = new File(tmpFolder.newFolder(), "r1-1.0.0.json");
        try (BufferedWriter writer = Files.newWriter((File)configFile, (Charset)Charsets.UTF_8);){
            writer.write("{ \"parents\": [ \"r2(2.0.0,1.0.0) \" ] }");
        }
        configReader.read(Id.Namespace.SYSTEM, configFile);
    }
}

