/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import co.cask.cdap.common.io.BinaryDecoder;
import co.cask.cdap.common.io.BinaryEncoder;
import co.cask.cdap.common.io.Encoder;
import co.cask.cdap.internal.io.ReflectionDatumReader;
import co.cask.cdap.internal.io.ReflectionDatumWriter;
import co.cask.cdap.internal.io.ReflectionSchemaGenerator;
import co.cask.cdap.internal.io.TypeRepresentation;
import co.cask.cdap.io.RecordWithString;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class DatumCodecTest {
    @Test
    public void testTypeProject() throws IOException, UnsupportedTypeException {
        final Record1 r1 = new Record1(10, Maps.newHashMap(), new URL("http://www.yahoo.com"));
        r1.properties.put(1, new Value(1, "Name1"));
        r1.properties.put(2, new Value(2, "Name2"));
        r1.properties.put(3, null);
        PipedOutputStream output = new PipedOutputStream();
        PipedInputStream input = new PipedInputStream(output);
        Schema sourceSchema = new ReflectionSchemaGenerator().generate(Record1.class);
        Schema targetSchema = new ReflectionSchemaGenerator().generate(Record2.class);
        new ReflectionDatumWriter(sourceSchema).encode((Object)r1, (Encoder)new BinaryEncoder((OutputStream)output));
        Record2 r2 = (Record2)new ReflectionDatumReader(targetSchema, TypeToken.of(Record2.class)).read((Object)new BinaryDecoder((InputStream)input), sourceSchema);
        Assert.assertEquals((long)10L, (long)r2.i);
        Assert.assertTrue((boolean)Iterables.all(r2.properties.entrySet(), (Predicate)new Predicate<Map.Entry<String, Value>>(){

            public boolean apply(Map.Entry<String, Value> input) {
                Value value = (Value)r1.properties.get(Integer.valueOf(input.getKey()));
                return value == null && input.getValue() == null || value.equals(input.getValue());
            }
        }));
        Assert.assertNull((Object)r2.name);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L}, (long[])r2.numbers);
        Assert.assertEquals((Object)URI.create("http://www.yahoo.com"), (Object)r2.url);
        Assert.assertEquals((Object)r1.uuid, (Object)r2.uuid);
    }

    @Test
    public void testCollection() throws UnsupportedTypeException, IOException {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"1", "2", "3"});
        Schema sourceSchema = new ReflectionSchemaGenerator().generate(new TypeToken<List<String>>(){}.getType());
        Schema targetSchema = new ReflectionSchemaGenerator().generate(new TypeToken<Set<String>>(){}.getType());
        PipedOutputStream output = new PipedOutputStream();
        PipedInputStream input = new PipedInputStream(output);
        new ReflectionDatumWriter(sourceSchema).encode((Object)list, (Encoder)new BinaryEncoder((OutputStream)output));
        Set set = (Set)new ReflectionDatumReader(targetSchema, (TypeToken)new TypeToken<Set<String>>(){}).read((Object)new BinaryDecoder((InputStream)input), sourceSchema);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"1", "2", "3"}), (Object)set);
        targetSchema = new ReflectionSchemaGenerator().generate(String[].class);
        new ReflectionDatumWriter(sourceSchema).encode((Object)list, (Encoder)new BinaryEncoder((OutputStream)output));
        Object[] array = (String[])new ReflectionDatumReader(targetSchema, (TypeToken)new TypeToken<String[]>(){}).read((Object)new BinaryDecoder((InputStream)input), sourceSchema);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])array);
    }

    @Test(expected=IOException.class)
    public void testCircularRef() throws UnsupportedTypeException, IOException {
        Schema schema = new ReflectionSchemaGenerator().generate(Node.class);
        Node head = new Node();
        head.next = new Node();
        head.next.next = head;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        new ReflectionDatumWriter(schema).encode((Object)head, (Encoder)new BinaryEncoder((OutputStream)output));
    }

    @Test
    public void test2() {
        float f = 0.56f;
        System.out.println(f);
    }

    @Test
    public void testReduceProjection() throws IOException, UnsupportedTypeException {
        PipedOutputStream output = new PipedOutputStream();
        PipedInputStream input = new PipedInputStream(output);
        Schema sourceSchema = new ReflectionSchemaGenerator().generate(MoreFields.class);
        Schema targetSchema = new ReflectionSchemaGenerator().generate(LessFields.class);
        MoreFields moreFields = new MoreFields(10, 20.2, "30", (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
        new ReflectionDatumWriter(sourceSchema).encode((Object)moreFields, (Encoder)new BinaryEncoder((OutputStream)output));
        LessFields lessFields = (LessFields)new ReflectionDatumReader(targetSchema, TypeToken.of(LessFields.class)).read((Object)new BinaryDecoder((InputStream)input), sourceSchema);
        Assert.assertEquals((Object)"30", (Object)lessFields.k);
        Assert.assertEquals((Object)moreFields.inner.b, (Object)lessFields.inner.b);
    }

    @Test
    public void testEnum() throws IOException, UnsupportedTypeException {
        PipedOutputStream output = new PipedOutputStream();
        PipedInputStream input = new PipedInputStream(output);
        Schema schema = new ReflectionSchemaGenerator().generate(TestEnum.class);
        ReflectionDatumWriter writer = new ReflectionDatumWriter(schema);
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)output);
        writer.encode((Object)TestEnum.VALUE1, (Encoder)encoder);
        writer.encode((Object)TestEnum.VALUE3, (Encoder)encoder);
        writer.encode((Object)TestEnum.VALUE2, (Encoder)encoder);
        BinaryDecoder decoder = new BinaryDecoder((InputStream)input);
        Schema readSchema = Schema.parseJson((String)schema.toString());
        ReflectionDatumReader reader = new ReflectionDatumReader(readSchema, TypeToken.of(TestEnum.class));
        Assert.assertEquals((Object)((Object)TestEnum.VALUE1), (Object)reader.read((Object)decoder, readSchema));
        Assert.assertEquals((Object)((Object)TestEnum.VALUE3), (Object)reader.read((Object)decoder, readSchema));
        Assert.assertEquals((Object)((Object)TestEnum.VALUE2), (Object)reader.read((Object)decoder, readSchema));
    }

    @Test
    public void testEmptyValue() throws UnsupportedTypeException, IOException {
        Schema schema = new ReflectionSchemaGenerator().generate(RecordWithString.class);
        TypeRepresentation typeRep = new TypeRepresentation(RecordWithString.class);
        ReflectionDatumWriter datumWriter = new ReflectionDatumWriter(schema);
        ReflectionDatumReader datumReader = new ReflectionDatumReader(schema, TypeToken.of((Type)typeRep.toType()));
        RecordWithString record = new RecordWithString();
        record.setA(42);
        record.setTheString("");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)bos);
        datumWriter.encode((Object)record, (Encoder)encoder);
        byte[] bytes = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        BinaryDecoder decoder = new BinaryDecoder((InputStream)bis);
        RecordWithString rec = (RecordWithString)datumReader.read((Object)decoder, schema);
        Assert.assertEquals((long)record.getA(), (long)rec.getA());
        Assert.assertEquals((Object)record.getTheString(), (Object)rec.getTheString());
    }

    public static enum TestEnum {
        VALUE1,
        VALUE2,
        VALUE3;

    }

    public static final class LessFields {
        String k;
        Inner inner;

        static final class Inner {
            String b;

            Inner() {
            }
        }
    }

    public static final class MoreFields {
        final int i;
        final double d;
        final String k;
        final List<String> list;
        final Inner inner;

        public MoreFields(int i, double d, String k, List<String> list) {
            this.i = i;
            this.d = d;
            this.k = k;
            this.list = list;
            this.inner = new Inner("inner");
        }

        static final class Inner {
            final Map<String, String> map;
            final String b;

            Inner(String b) {
                this.b = b;
                this.map = ImmutableMap.of((Object)"b", (Object)b);
            }
        }
    }

    public static final class Node {
        int d;
        Node next;
    }

    public static class Record2 {
        private final Long i;
        private final Map<String, Value> properties;
        private final String name;
        private final long[] numbers;
        private final URI url;
        private final UUID uuid;
        private final String nullStr;

        public Record2(long i, Map<String, Value> properties, String name) {
            this.i = i;
            this.properties = properties;
            this.name = name;
            this.numbers = new long[0];
            this.url = null;
            this.uuid = null;
            this.nullStr = null;
        }
    }

    public static class Record1 {
        private final int i;
        private final Map<Integer, Value> properties;
        private final int[] numbers;
        private final URL url;
        private final UUID uuid;
        private final String nullStr;

        public Record1(int i, Map<Integer, Value> properties, URL url) {
            this.i = i;
            this.properties = properties;
            this.numbers = new int[]{1, 2};
            this.url = url;
            this.uuid = UUID.randomUUID();
            this.nullStr = null;
        }
    }

    public static class Value {
        private final int id;
        private final String name;

        public Value(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.id == value.id && this.name.equals(value.name);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return "Value{id=" + this.id + ", name='" + this.name + '\'' + '}';
        }
    }
}

