/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.common.io.ByteBuffers;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class ByteBuffersTest {
    @Test
    public void testWriteArrayByteBuffer() throws IOException {
        String content = "0123456789";
        this.testWriteBuffer(ByteBuffer.wrap(content.getBytes(Charsets.UTF_8)), content);
    }

    @Test
    public void testWriteDirectByteBuffer() throws IOException {
        String content = "0123456789";
        ByteBuffer buffer = ByteBuffer.allocateDirect(20);
        buffer.put(content.getBytes(Charsets.UTF_8));
        buffer.flip();
        this.testWriteBuffer(buffer, content);
        buffer = ByteBuffer.allocateDirect(128000);
        content = Strings.repeat((String)content, (int)(buffer.remaining() / content.length()));
        buffer.put(content.getBytes(Charsets.UTF_8));
        buffer.flip();
        this.testWriteBuffer(buffer, content);
    }

    private void testWriteBuffer(ByteBuffer buffer, String content) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteBuffers.writeToStream((ByteBuffer)buffer, (OutputStream)os);
        Assert.assertEquals((Object)content, (Object)new String(os.toByteArray(), Charsets.UTF_8));
        int pos = content.length() / 2;
        buffer.position(pos);
        os.reset();
        ByteBuffers.writeToStream((ByteBuffer)buffer, (OutputStream)os);
        Assert.assertEquals((Object)content.substring(pos), (Object)new String(os.toByteArray(), Charsets.UTF_8));
        pos = content.length() / 3;
        buffer.position(pos);
        os.reset();
        ByteBuffers.writeToStream((ByteBuffer)buffer.slice(), (OutputStream)os);
        Assert.assertEquals((Object)content.substring(pos), (Object)new String(os.toByteArray(), Charsets.UTF_8));
    }
}

