/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.zookeeper.election;

import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.common.zookeeper.election.LeaderElectionInfoService;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.twill.api.ElectionHandler;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.apache.twill.internal.zookeeper.LeaderElection;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionInfoServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderElectionInfoServiceTest.class);
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private static InMemoryZKServer zkServer;

    @BeforeClass
    public static void init() throws IOException {
        zkServer = InMemoryZKServer.builder().setDataDir(TEMP_FOLDER.newFolder()).build();
        zkServer.startAndWait();
    }

    @AfterClass
    public static void finish() {
        zkServer.stopAndWait();
    }

    @Test
    public void testParticipants() throws Exception {
        int size = 5;
        String prefix = "/election";
        ArrayList<ZKClientService> zkClients = new ArrayList<ZKClientService>();
        ZKClientService infoZKClient = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
        infoZKClient.startAndWait();
        zkClients.add(infoZKClient);
        LeaderElectionInfoService infoService = new LeaderElectionInfoService((ZKClient)infoZKClient, prefix);
        infoService.startAndWait();
        try {
            infoService.getParticipants(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected timeout");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        ArrayList<LeaderElection> leaderElections = new ArrayList<LeaderElection>();
        int i = 0;
        while (i < 5) {
            ZKClientService zkClient = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
            zkClient.startAndWait();
            zkClients.add(zkClient);
            final int participantId = i++;
            LeaderElection leaderElection = new LeaderElection((ZKClient)zkClient, prefix, new ElectionHandler(){

                public void leader() {
                    LOG.info("Leader: {}", (Object)participantId);
                }

                public void follower() {
                    LOG.info("Follow: {}", (Object)participantId);
                }
            });
            leaderElection.start();
            leaderElections.add(leaderElection);
        }
        final SortedMap participants = infoService.getParticipants(5L, TimeUnit.SECONDS);
        Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (participants.size() != 5) {
                    return false;
                }
                return Iterables.all(participants.values(), (Predicate)new Predicate<LeaderElectionInfoService.Participant>(){

                    public boolean apply(LeaderElectionInfoService.Participant input) {
                        return input.getHostname() != null;
                    }
                });
            }
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        SortedMap snapshot = infoService.fetchCurrentParticipants();
        Assert.assertEquals((long)5L, (long)snapshot.size());
        Assert.assertEquals((Object)participants, (Object)snapshot);
        int expectedSize = 5;
        for (LeaderElection leaderElection : leaderElections) {
            leaderElection.stopAndWait();
            Tasks.waitFor((Object)(--expectedSize), (Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return participants.size();
                }
            }, (long)5L, (TimeUnit)TimeUnit.SECONDS, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        snapshot = infoService.fetchCurrentParticipants();
        Assert.assertTrue((boolean)snapshot.isEmpty());
        Assert.assertEquals((Object)participants, (Object)snapshot);
        infoService.stopAndWait();
        for (ZKClientService zkClient : zkClients) {
            zkClient.stopAndWait();
        }
    }
}

