/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.zookeeper;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.common.io.Codec;
import co.cask.cdap.common.zookeeper.ZKExtOperations;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZKExtOperationsTest {
    private static final Codec<Integer> INT_CODEC = new Codec<Integer>(){

        public byte[] encode(Integer object) throws IOException {
            return Bytes.toBytes((int)object);
        }

        public Integer decode(byte[] data) throws IOException {
            return Bytes.toInt((byte[])data);
        }
    };
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();
    private static InMemoryZKServer zkServer;

    @BeforeClass
    public static void init() throws IOException {
        zkServer = InMemoryZKServer.builder().setDataDir(tmpFolder.newFolder()).build();
        zkServer.startAndWait();
    }

    @Test
    public void testGetAndSet() throws Exception {
        String path = "/testGetAndSet";
        ZKClientService zkClient1 = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
        ZKClientService zkClient2 = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
        zkClient1.startAndWait();
        zkClient2.startAndWait();
        ZKExtOperations.updateOrCreate((ZKClient)zkClient1, (String)path, (Function)new Function<Integer, Integer>(){

            @Nullable
            public Integer apply(@Nullable Integer input) {
                Assert.assertNull((Object)input);
                return 0;
            }
        }, INT_CODEC).get(10L, TimeUnit.SECONDS);
        ZKExtOperations.updateOrCreate((ZKClient)zkClient2, (String)path, (Function)new Function<Integer, Integer>(){

            @Nullable
            public Integer apply(@Nullable Integer input) {
                Assert.assertEquals((long)0L, (long)input.intValue());
                return 1;
            }
        }, INT_CODEC).get(10L, TimeUnit.SECONDS);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Function<Integer, Integer> modifier = new Function<Integer, Integer>(){

            @Nullable
            public Integer apply(@Nullable Integer input) {
                try {
                    if (input == 1) {
                        barrier.await();
                        return 2;
                    }
                    if (input == 2) {
                        return 3;
                    }
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                throw new IllegalStateException("Illegal input " + input);
            }
        };
        ListenableFuture future1 = ZKExtOperations.updateOrCreate((ZKClient)zkClient1, (String)path, (Function)modifier, INT_CODEC);
        ListenableFuture future2 = ZKExtOperations.updateOrCreate((ZKClient)zkClient2, (String)path, (Function)modifier, INT_CODEC);
        int r1 = (Integer)future1.get(10L, TimeUnit.SECONDS);
        int r2 = (Integer)future2.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((r1 == 2 && r2 == 3 || r1 == 3 && r2 == 2 ? 1 : 0) != 0);
        Integer result = (Integer)ZKExtOperations.updateOrCreate((ZKClient)zkClient1, (String)path, (Function)new Function<Integer, Integer>(){

            @Nullable
            public Integer apply(@Nullable Integer input) {
                return input == 3 ? null : Integer.valueOf(4);
            }
        }, INT_CODEC).get();
        Assert.assertNull((Object)result);
        zkClient1.stopAndWait();
        zkClient2.stopAndWait();
    }

    @Test
    public void testCreateOrSet() throws Exception {
        String path = "/parent/testCreateOrSet";
        ZKClientService zkClient = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
        zkClient.startAndWait();
        Assert.assertEquals((long)1L, (long)((Integer)ZKExtOperations.createOrSet((ZKClient)zkClient, (String)path, (Supplier)Suppliers.ofInstance((Object)1), INT_CODEC, (int)0).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)INT_CODEC.decode(((NodeData)zkClient.getData(path).get()).getData())).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)ZKExtOperations.createOrSet((ZKClient)zkClient, (String)path, (Supplier)Suppliers.ofInstance((Object)2), INT_CODEC, (int)0).get()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)INT_CODEC.decode(((NodeData)zkClient.getData(path).get()).getData())).intValue());
        zkClient.stopAndWait();
    }

    @Test
    public void testSetOrCreate() throws Exception {
        String path = "/parent/testSetOrCreate";
        ZKClientService zkClient = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
        zkClient.startAndWait();
        Assert.assertEquals((long)1L, (long)((Integer)ZKExtOperations.setOrCreate((ZKClient)zkClient, (String)path, (Supplier)Suppliers.ofInstance((Object)1), INT_CODEC, (int)0).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)INT_CODEC.decode(((NodeData)zkClient.getData(path).get()).getData())).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)ZKExtOperations.setOrCreate((ZKClient)zkClient, (String)path, (Supplier)Suppliers.ofInstance((Object)2), INT_CODEC, (int)0).get()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)INT_CODEC.decode(((NodeData)zkClient.getData(path).get()).getData())).intValue());
        zkClient.stopAndWait();
    }

    @AfterClass
    public static void finish() {
        zkServer.stopAndWait();
    }
}

