/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.utils;

import co.cask.cdap.common.utils.TimeMathParser;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class TimeMathParserTest {
    @Test
    public void testGetNowInSeconds() {
        long now = TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        long result = TimeMathParser.nowInSeconds();
        Assert.assertTrue((result - now == 1L || result == now ? 1 : 0) != 0);
    }

    @Test
    public void testParseTimestamp() {
        Assert.assertEquals((long)1234567890L, (long)TimeMathParser.parseTimeInSeconds((String)"1234567890"));
        Assert.assertEquals((long)1234567890L, (long)TimeMathParser.parseTimeInSeconds((long)0L, (String)"1234567890"));
    }

    @Test
    public void testParseNow() {
        long now = TimeMathParser.nowInSeconds();
        long result = TimeMathParser.parseTimeInSeconds((String)"now");
        Assert.assertTrue((result - now == 1L || result == now ? 1 : 0) != 0);
        Assert.assertEquals((long)1234567890L, (long)TimeMathParser.parseTimeInSeconds((long)1234567890L, (String)"now"));
    }

    @Test
    public void testOneOperation() {
        long now = TimeMathParser.nowInSeconds();
        Assert.assertEquals((long)(now - 7L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now-7s"));
        Assert.assertEquals((long)(now - 420L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now-7m"));
        Assert.assertEquals((long)(now - 25200L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now-7h"));
        Assert.assertEquals((long)(now - 604800L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now-7d"));
        Assert.assertEquals((long)(now + 7L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now+7s"));
        Assert.assertEquals((long)(now + 420L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now+7m"));
        Assert.assertEquals((long)(now + 25200L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now+7h"));
        Assert.assertEquals((long)(now + 604800L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now+7d"));
        Assert.assertEquals((float)(System.currentTimeMillis() - 10L), (float)TimeMathParser.parseTime((String)"now-10ms", (TimeUnit)TimeUnit.MILLISECONDS), (float)1.0f);
        Assert.assertEquals((float)(System.currentTimeMillis() + 50L), (float)TimeMathParser.parseTime((String)"now+50ms", (TimeUnit)TimeUnit.MILLISECONDS), (float)1.0f);
    }

    @Test
    public void testResolutionParsing() {
        String resolution = "60s";
        Assert.assertEquals((long)60L, (long)TimeMathParser.resolutionInSeconds((String)resolution));
        resolution = "2m";
        Assert.assertEquals((long)120L, (long)TimeMathParser.resolutionInSeconds((String)resolution));
        resolution = "3h";
        Assert.assertEquals((long)10800L, (long)TimeMathParser.resolutionInSeconds((String)resolution));
        resolution = "1d";
        Assert.assertEquals((long)86400L, (long)TimeMathParser.resolutionInSeconds((String)resolution));
        resolution = "1h3m";
        Assert.assertEquals((long)3780L, (long)TimeMathParser.resolutionInSeconds((String)resolution));
    }

    @Test
    public void testMultipleOperations() {
        long now = TimeMathParser.nowInSeconds();
        Assert.assertEquals((long)(now - 604800L + 10800L - 780L + 11L), (long)TimeMathParser.parseTimeInSeconds((long)now, (String)"now-7d+3h-13m+11s"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSpaceInsteadOfPlusThrowsException() {
        long now = TimeMathParser.nowInSeconds();
        TimeMathParser.parseTimeInSeconds((long)now, (String)"now 6h");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGibberishInMiddleThrowsException() {
        long now = TimeMathParser.nowInSeconds();
        TimeMathParser.parseTimeInSeconds((long)now, (String)"now-3d+23lnkfasd-6h");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidOperationThrowsException() {
        long now = TimeMathParser.nowInSeconds();
        TimeMathParser.parseTimeInSeconds((long)now, (String)"now/1d");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUnitThrowsException() {
        long now = TimeMathParser.nowInSeconds();
        TimeMathParser.parseTimeInSeconds((long)now, (String)"now-1w");
    }
}

