/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.utils;

import co.cask.cdap.common.utils.Networks;
import org.junit.Assert;
import org.junit.Test;

public class NetworksTest {
    @Test
    public void testNormalizeHost() throws Exception {
        Assert.assertEquals((Object)"www1_abc_com", (Object)Networks.normalizeWebappDiscoveryName((String)"www1.abc.com:80"));
        Assert.assertEquals((Object)"www_abc_com", (Object)Networks.normalizeWebappDiscoveryName((String)"www.abc.com:80"));
        Assert.assertEquals((Object)"www1_abc_com_8080", (Object)Networks.normalizeWebappDiscoveryName((String)"www1.abc.com:8080"));
        Assert.assertEquals((Object)"www_abc_com_8080", (Object)Networks.normalizeWebappDiscoveryName((String)"www.abc.com:8080"));
        Assert.assertEquals((Object)"www1_abc_com_path", (Object)Networks.normalizeWebappDiscoveryName((String)"www1.abc.com:80/path"));
        Assert.assertEquals((Object)"www_abc_com_path", (Object)Networks.normalizeWebappDiscoveryName((String)"www.abc.com:80/path"));
        Assert.assertEquals((Object)"www1_abc_com_8080_path", (Object)Networks.normalizeWebappDiscoveryName((String)"www1.abc.com:8080/path"));
        Assert.assertEquals((Object)"www_abc_com_8080_path", (Object)Networks.normalizeWebappDiscoveryName((String)"www.abc.com:8080/path/"));
        Assert.assertEquals((Object)"www1_abc%40def_com", (Object)Networks.normalizeWebappDiscoveryName((String)"www1.abc@def.com:80"));
        Assert.assertEquals((Object)"www_abc%40def_com", (Object)Networks.normalizeWebappDiscoveryName((String)"www.abc@def.com:80"));
        Assert.assertEquals((Object)"www1_abc_def_com_8080", (Object)Networks.normalizeWebappDiscoveryName((String)"www1.abc/def.com:8080"));
        Assert.assertEquals((Object)"www_abc%40def_com_8080", (Object)Networks.normalizeWebappDiscoveryName((String)"www.abc@def.com:8080"));
    }
}

