/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.utils;

import co.cask.cdap.common.utils.ImmutablePair;
import org.junit.Assert;
import org.junit.Test;

public class ImmutablePairTest {
    @Test
    public void testGetFirst() throws Exception {
        Assert.assertEquals(Integer.class, ((Integer)Fixture.a.getFirst()).getClass());
        Assert.assertEquals((long)1L, (long)((Integer)Fixture.a.getFirst()).intValue());
    }

    @Test
    public void testGetSecond() throws Exception {
        Assert.assertEquals(Integer.class, ((Integer)Fixture.a.getSecond()).getClass());
        Assert.assertEquals((long)2L, (long)((Integer)Fixture.a.getSecond()).intValue());
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertNotNull((Object)Fixture.b.toString());
        Assert.assertEquals((Object)"ImmutablePair{first=1, second=woot}", (Object)Fixture.b.toString());
    }

    @Test
    public void testSelf() throws Exception {
        Assert.assertTrue((boolean)Fixture.a.equals(Fixture.a));
        Assert.assertTrue((boolean)Fixture.b.equals(Fixture.b));
        Assert.assertTrue((boolean)Fixture.c.equals(Fixture.c));
    }

    @Test
    public void testIncompatibleTypes() throws Exception {
        Assert.assertFalse((boolean)Fixture.a.equals(Fixture.c));
        Assert.assertFalse((boolean)Fixture.a.equals(Fixture.b));
    }

    @Test
    public void testNullReferences() throws Exception {
        Assert.assertFalse((boolean)Fixture.a.equals(null));
    }

    @Test
    public void testEqualsIsReflexive() {
        Assert.assertTrue((boolean)Fixture.a.equals(Fixture.d));
    }

    @Test
    public void testEqualsIsTransitive() {
        Assert.assertTrue((boolean)Fixture.a.equals(Fixture.d));
        Assert.assertTrue((boolean)Fixture.d.equals(Fixture.e));
        Assert.assertTrue((boolean)Fixture.e.equals(Fixture.a));
    }

    @Test
    public void testEqualsTypeSafe() {
        ImmutablePair pair1 = new ImmutablePair((Object)1, (Object)true);
        ImmutablePair pair2 = new ImmutablePair((Object)"1", (Object)"true".getBytes());
        Assert.assertFalse((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair2.equals((Object)pair1));
        Assert.assertFalse((boolean)pair1.equals((Object)new Integer(10)));
    }

    @Test
    public void testHashCodeConsistency() throws Exception {
        int hashcode = Fixture.a.hashCode();
        Assert.assertEquals((long)hashcode, (long)Fixture.a.hashCode());
        Assert.assertEquals((long)hashcode, (long)Fixture.a.hashCode());
    }

    @Test
    public void testTwoSameObjectHashCode() throws Exception {
        Assert.assertEquals((long)Fixture.a.hashCode(), (long)Fixture.d.hashCode());
        Assert.assertEquals((long)Fixture.d.hashCode(), (long)Fixture.e.hashCode());
        Assert.assertEquals((long)Fixture.e.hashCode(), (long)Fixture.a.hashCode());
    }

    @Test
    public void testTwoDifferentObjectHashCode() throws Exception {
        Assert.assertTrue((Fixture.a.hashCode() != Fixture.c.hashCode() ? 1 : 0) != 0);
    }

    static final class Fixture {
        static ImmutablePair<Integer, Integer> a = new ImmutablePair((Object)1, (Object)2);
        static ImmutablePair<Integer, String> b = new ImmutablePair((Object)1, (Object)"woot");
        static ImmutablePair<String, String> c = new ImmutablePair((Object)"me", (Object)"you");
        static ImmutablePair<Integer, Integer> d = new ImmutablePair((Object)1, (Object)2);
        static ImmutablePair<Integer, Integer> e = new ImmutablePair((Object)1, (Object)2);

        Fixture() {
        }
    }
}

