/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.logging;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SyncTest {
    MiniDFSCluster dfsCluster = null;
    Configuration config = null;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void startDFS() throws IOException {
        File dfsPath = this.tempFolder.newFolder();
        System.setProperty("test.build.data", dfsPath.toString());
        System.setProperty("test.cache.data", dfsPath.toString());
        System.out.println("Starting up Mini DFS cluster...");
        this.config = new HdfsConfiguration();
        this.dfsCluster = new MiniDFSCluster.Builder(this.config).numDataNodes(2).format(true).build();
        this.dfsCluster.waitClusterUp();
        System.out.println("Mini DFS is started.");
        this.config.set("fs.defaultFS", this.dfsCluster.getFileSystem().getUri().toString());
    }

    @After
    public void stopDFS() throws IOException {
        System.out.println("Shutting down Mini DFS cluster...");
        this.dfsCluster.shutdown();
        System.out.println("Mini DFS is shut down.");
    }

    @Test
    @Ignore
    public void testSync() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.config);
        Path path = new Path("/myfile");
        FSDataOutputStream out = fs.create(path, false, 4096, (short)2, 4096L);
        int numBytes = 5000;
        for (int i = 0; i < numBytes; ++i) {
            out.write((int)((byte)i));
        }
        out.hflush();
        Assert.assertTrue((boolean)fs.exists(path));
        FSDataInputStream in = fs.open(path);
        byte[] buffer = new byte[numBytes];
        in.readFully(buffer);
        for (int i = 0; i < numBytes; ++i) {
            Assert.assertEquals((long)((byte)i), (long)buffer[i]);
        }
        in.close();
        out.close();
    }
}

