/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.lang;

import co.cask.cdap.internal.lang.Reflections;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionsTest {
    @Test
    public void testResolved() throws Exception {
        Assert.assertTrue((boolean)Reflections.isResolved(String.class));
        Assert.assertTrue((boolean)Reflections.isResolved((Type)new TypeToken<Map<String, Set<Integer>>>(){}.getType()));
        TypeToken<Record<Set<Integer>>> typeToken = new TypeToken<Record<Set<Integer>>>(){};
        Type arrayType = Record.class.getMethod("getArray", new Class[0]).getGenericReturnType();
        Assert.assertFalse((boolean)Reflections.isResolved((Type)arrayType));
        Assert.assertTrue((boolean)Reflections.isResolved((Type)typeToken.resolveType(arrayType).getType()));
    }

    private static interface Record<T> {
        public T get();

        public T[] getArray();
    }
}

