/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.io;

import co.cask.cdap.common.io.Locations;
import co.cask.cdap.common.io.SeekableInputStream;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.hadoop.fs.Syncable;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class SeekableInputStreamTestBase {
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();

    protected abstract LocationFactory getLocationFactory();

    @Test
    public void testClosedStream() throws IOException {
        Location location = this.getLocationFactory().create("testClosed");
        byte[] bytes = new byte[1024];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(i & 0xFF);
        }
        OutputStream output = (OutputStream)Locations.newOutputSupplier((Location)location).getOutput();
        output.write(bytes);
        output.close();
        InputSupplier inputSupplier = Locations.newInputSupplier((Location)location);
        SeekableInputStream input = (SeekableInputStream)inputSupplier.getInput();
        Assert.assertEquals((long)bytes.length, (long)input.size());
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            long pos = random.nextInt(bytes.length);
            input.seek(pos);
            Assert.assertEquals((long)(pos % 256L), (long)input.read());
        }
        input.close();
    }

    @Test
    public void testLiveStream() throws IOException {
        long pos;
        int i;
        Location location = this.getLocationFactory().create("testSeekable");
        byte[] bytes = new byte[1024];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)(i2 & 0xFF);
        }
        OutputStream output = (OutputStream)Locations.newOutputSupplier((Location)location).getOutput();
        output.write(bytes);
        this.sync(output);
        InputSupplier inputSupplier = Locations.newInputSupplier((Location)location);
        SeekableInputStream input = (SeekableInputStream)inputSupplier.getInput();
        Assert.assertEquals((long)bytes.length, (long)input.size());
        Random random = new Random();
        for (i = 0; i < 100; ++i) {
            pos = random.nextInt(bytes.length);
            input.seek(pos);
            Assert.assertEquals((long)(pos % 256L), (long)input.read());
        }
        input.close();
        output.write(bytes);
        this.sync(output);
        input = (SeekableInputStream)inputSupplier.getInput();
        Assert.assertEquals((long)(bytes.length * 2), (long)input.size());
        for (i = 0; i < 100; ++i) {
            pos = random.nextInt(bytes.length * 2);
            input.seek(pos);
            Assert.assertEquals((long)(pos % 256L), (long)input.read());
        }
        output.close();
        input.close();
    }

    private void sync(OutputStream output) throws IOException {
        if (output instanceof Syncable) {
            ((Syncable)output).hsync();
        } else {
            output.flush();
        }
    }
}

