/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.io;

import co.cask.cdap.common.io.Locations;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.junit.Assert;
import org.junit.Test;

public class LocationsTest {
    private static final String TEST_BASE_PATH = "test_base";
    private static final String TEST_PATH = "some/test/path";

    @Test
    public void absolutePathTests() throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://1.2.3.4:8020/");
        FileContextLocationFactory locationFactory = new FileContextLocationFactory(conf, TEST_BASE_PATH);
        Location location1 = locationFactory.create(TEST_PATH);
        Location location2 = Locations.getLocationFromAbsolutePath((LocationFactory)locationFactory, (String)location1.toURI().getPath());
        Assert.assertEquals((Object)location1.toURI(), (Object)location2.toURI());
        conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        locationFactory = new FileContextLocationFactory(conf, TEST_BASE_PATH);
        location1 = locationFactory.create(TEST_PATH);
        location2 = Locations.getLocationFromAbsolutePath((LocationFactory)locationFactory, (String)location1.toURI().getPath());
        Assert.assertEquals((Object)location1.toURI(), (Object)location2.toURI());
        locationFactory = new LocalLocationFactory(new File(TEST_BASE_PATH));
        location1 = locationFactory.create(TEST_PATH);
        location2 = Locations.getLocationFromAbsolutePath((LocationFactory)locationFactory, (String)location1.toURI().getPath());
        Assert.assertEquals((Object)location1.toURI(), (Object)location2.toURI());
    }
}

