/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.election;

import co.cask.cdap.common.election.InMemoryElectionRegistry;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.twill.api.ElectionHandler;
import org.apache.twill.common.Cancellable;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryElectionTest {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryElectionTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testElection() throws ExecutionException, InterruptedException, BrokenBarrierException {
        final InMemoryElectionRegistry electionRegistry = new InMemoryElectionRegistry();
        ExecutorService executor = Executors.newCachedThreadPool();
        int participantCount = 5;
        final CyclicBarrier barrier = new CyclicBarrier(participantCount + 1);
        final Semaphore leaderSem = new Semaphore(0);
        final Semaphore followerSem = new Semaphore(0);
        final CountDownLatch[] stopLatch = new CountDownLatch[participantCount];
        try {
            final AtomicInteger currentLeader = new AtomicInteger(-1);
            int i = 0;
            while (i < participantCount) {
                stopLatch[i] = new CountDownLatch(1);
                final int idx = i++;
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            barrier.await();
                            Cancellable cancel = electionRegistry.join("test", new ElectionHandler(){

                                public void leader() {
                                    currentLeader.set(idx);
                                    leaderSem.release();
                                }

                                public void follower() {
                                    followerSem.release();
                                }
                            });
                            stopLatch[idx].await(10L, TimeUnit.SECONDS);
                            cancel.cancel();
                        }
                        catch (Exception e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
            barrier.await();
            leaderSem.tryAcquire(10L, TimeUnit.SECONDS);
            followerSem.tryAcquire(participantCount - 1, 10L, TimeUnit.SECONDS);
            for (i = 0; i < participantCount - 1; ++i) {
                stopLatch[currentLeader.get()].countDown();
                leaderSem.tryAcquire(10L, TimeUnit.SECONDS);
                followerSem.tryAcquire(10L, TimeUnit.SECONDS);
            }
            stopLatch[currentLeader.get()].countDown();
            followerSem.tryAcquire(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }
}

