/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import co.cask.cdap.common.conf.PropertyStore;
import co.cask.cdap.common.conf.PropertyStoreTestBase;
import co.cask.cdap.common.io.Codec;
import co.cask.cdap.common.zookeeper.store.ZKPropertyStore;
import java.io.IOException;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class ZKPropertyStoreTest
extends PropertyStoreTestBase {
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();
    private static InMemoryZKServer zkServer;
    private static ZKClientService zkClient;

    @BeforeClass
    public static void init() throws IOException {
        zkServer = InMemoryZKServer.builder().setDataDir(tmpFolder.newFolder()).build();
        zkServer.startAndWait();
        zkClient = ZKClientService.Builder.of((String)zkServer.getConnectionStr()).build();
        zkClient.startAndWait();
    }

    @AfterClass
    public static void finish() {
        zkClient.stopAndWait();
        zkServer.stopAndWait();
    }

    @Override
    protected <T> PropertyStore<T> createPropertyStore(Codec<T> codec) {
        return ZKPropertyStore.create((ZKClient)zkClient, codec);
    }
}

