/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import co.cask.cdap.common.conf.AbstractPropertyChangeListener;
import co.cask.cdap.common.conf.PropertyChangeListener;
import co.cask.cdap.common.conf.PropertyStore;
import co.cask.cdap.common.conf.PropertyUpdater;
import co.cask.cdap.common.conf.SyncPropertyUpdater;
import co.cask.cdap.common.io.Codec;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;

public abstract class PropertyStoreTestBase {
    private static final Codec<String> STRING_CODEC = new Codec<String>(){

        public byte[] encode(String object) throws IOException {
            return object.getBytes(Charsets.UTF_8);
        }

        public String decode(byte[] data) throws IOException {
            return new String(data, Charsets.UTF_8);
        }
    };

    protected abstract <T> PropertyStore<T> createPropertyStore(Codec<T> var1);

    @Test
    public void testBasicStore() throws InterruptedException, IOException {
        PropertyStore<String> store = this.createPropertyStore(STRING_CODEC);
        final LinkedBlockingQueue changes = new LinkedBlockingQueue();
        store.addChangeListener("basic", (PropertyChangeListener)new AbstractPropertyChangeListener<String>(){

            public void onChange(String name, String property) {
                changes.add(property);
            }
        });
        store.set("basic", (Object)"basic");
        Assert.assertEquals((Object)"basic", changes.poll(5L, TimeUnit.SECONDS));
        store.addChangeListener("basic", (PropertyChangeListener)new AbstractPropertyChangeListener<String>(){

            public void onChange(String name, String property) {
                changes.add(property);
            }
        });
        Assert.assertEquals((Object)"basic", changes.poll(5L, TimeUnit.SECONDS));
        store.update("basic", (PropertyUpdater)new SyncPropertyUpdater<String>(){

            protected String compute(@Nullable String property) {
                if ("basic".equals(property)) {
                    return property + "." + property;
                }
                return null;
            }
        });
        Assert.assertEquals((Object)"basic.basic", changes.poll(5L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)"basic.basic", changes.poll(5L, TimeUnit.SECONDS));
        Assert.assertNull(changes.poll(2L, TimeUnit.SECONDS));
        store.close();
    }
}

