/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import co.cask.cdap.common.conf.ConfigurationUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationUtilTest {
    @Test
    public void testNamedConfigurations() throws IOException {
        Configuration conf = new Configuration();
        ImmutableMap name1Config = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        ImmutableMap name2Config = ImmutableMap.of((Object)"name2key", (Object)"name2value");
        ImmutableMap nameDotConfig = ImmutableMap.of((Object)"name3key", (Object)"name3value");
        ImmutableMap emptyConfig = ImmutableMap.of();
        ConfigurationUtil.setNamedConfigurations((Configuration)conf, (String)"name1", (Map)name1Config);
        ConfigurationUtil.setNamedConfigurations((Configuration)conf, (String)"name2", (Map)name2Config);
        ConfigurationUtil.setNamedConfigurations((Configuration)conf, (String)"name.", (Map)nameDotConfig);
        ConfigurationUtil.setNamedConfigurations((Configuration)conf, (String)"emptyConfig", (Map)emptyConfig);
        Assert.assertEquals((Object)name1Config, (Object)ConfigurationUtil.getNamedConfigurations((Configuration)conf, (String)"name1"));
        Assert.assertEquals((Object)name2Config, (Object)ConfigurationUtil.getNamedConfigurations((Configuration)conf, (String)"name2"));
        Assert.assertEquals((Object)nameDotConfig, (Object)ConfigurationUtil.getNamedConfigurations((Configuration)conf, (String)"name."));
        Assert.assertEquals((Object)emptyConfig, (Object)ConfigurationUtil.getNamedConfigurations((Configuration)conf, (String)"emptyConfig"));
    }
}

