/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.conf.CConfigurationUtil;
import org.junit.Assert;
import org.junit.Test;

public class CConfigurationUtilTest {
    @Test
    public void testCheckCConfValidity() throws Exception {
        CConfiguration cConf = CConfiguration.create();
        this.assertIsValidCConf(cConf);
        cConf.set("root.namespace", "invalid_root");
        this.assertIsInvalidCConf(cConf);
        cConf.set("root.namespace", "invalid.root");
        this.assertIsInvalidCConf(cConf);
        cConf.set("dataset.table.prefix", "invalid/root");
        this.assertIsInvalidCConf(cConf);
        cConf.set("root.namespace", "invalid\root");
        this.assertIsInvalidCConf(cConf);
        cConf.set("root.namespace", "cdap");
        cConf.set("dataset.table.prefix", "dsprefix");
        this.assertIsValidCConf(cConf);
        cConf.set("root.namespace", "cdap1");
        this.assertIsValidCConf(cConf);
        cConf = CConfiguration.create();
        cConf.set("dataset.table.prefix", "invalid.table.prefix");
        this.assertIsInvalidCConf(cConf);
        cConf.set("root.namespace", "invalid/root/prefix");
        this.assertIsInvalidCConf(cConf);
    }

    private void assertIsInvalidCConf(CConfiguration cConf) {
        try {
            CConfigurationUtil.verify((CConfiguration)cConf);
            Assert.fail((String)"Expected cConf to be invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertIsValidCConf(CConfiguration cConf) {
        CConfigurationUtil.verify((CConfiguration)cConf);
    }
}

