/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.internal.io.ASMFieldAccessorFactory;
import co.cask.cdap.internal.io.FieldAccessor;
import com.google.common.reflect.TypeToken;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessorTest {
    @Test
    public void testGetter() {
        TypeToken type = TypeToken.of(Child.class);
        ASMFieldAccessorFactory factory = new ASMFieldAccessorFactory();
        FieldAccessor accessor = factory.getFieldAccessor(type, "integer");
        Assert.assertSame((Object)accessor, (Object)factory.getFieldAccessor(type, "integer"));
        Child c = new Child();
        c.integer = 10;
        c.str = "child value";
        ((Parent)c).value = "string value";
        ((Parent)c).b = true;
        Assert.assertEquals((long)c.integer, (long)accessor.getInt((Object)c));
        Assert.assertSame((Object)c.str, (Object)factory.getFieldAccessor(type, "str").get((Object)c));
        Assert.assertSame((Object)((Parent)c).value, (Object)factory.getFieldAccessor(type, "value").get((Object)c));
        Assert.assertEquals((Object)((Parent)c).b, (Object)factory.getFieldAccessor(type, "b").get((Object)c));
    }

    @Test
    public void testSetter() {
        TypeToken type = TypeToken.of(Child.class);
        ASMFieldAccessorFactory factory = new ASMFieldAccessorFactory();
        Child c = new Child();
        c.integer = 10;
        c.str = "child value";
        ((Parent)c).value = "string value";
        ((Parent)c).b = true;
        Child c2 = new Child();
        factory.getFieldAccessor(type, "integer").setInt((Object)c2, c.integer);
        factory.getFieldAccessor(type, "str").set((Object)c2, (Object)c.str);
        factory.getFieldAccessor(type, "value").set((Object)c2, ((Parent)c).value);
        factory.getFieldAccessor(type, "b").setBoolean((Object)c2, ((Parent)c).b);
        Assert.assertEquals((long)c.integer, (long)c2.integer);
        Assert.assertSame((Object)c.str, (Object)c2.str);
        Assert.assertSame((Object)((Parent)c).value, (Object)((Parent)c2).value);
        Assert.assertEquals((Object)((Parent)c).b, (Object)((Parent)c2).b);
    }

    public static class Child
    extends Parent<String> {
        protected String str;
        int integer;
    }

    public static class Parent<T> {
        private T value;
        private boolean b;
    }
}

