/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.lang.jar;

import co.cask.cdap.common.io.Locations;
import co.cask.cdap.common.lang.jar.BundleJarUtil;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.twill.filesystem.Location;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BundleJarUtilTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();

    @Test
    public void testPackingDir() throws IOException {
        this.testNumFiles(10, false);
    }

    @Test
    public void testPackingEmptyDir() throws IOException {
        this.testNumFiles(0, false);
    }

    @Test
    public void testPackingFile() throws IOException {
        this.testNumFiles(1, true);
    }

    @Test
    public void testRecursive() throws IOException {
        File dir = TEMP_FOLDER.newFolder();
        File subDir = new File(dir, "subdir");
        subDir.mkdirs();
        String message = Strings.repeat((String)"0123456789", (int)40);
        File file1 = new File(subDir, "file1");
        Files.write((CharSequence)message, (File)file1, (Charset)Charsets.UTF_8);
        final File target = new File(TEMP_FOLDER.newFolder(), "target.jar");
        BundleJarUtil.createArchive((File)dir, (OutputSupplier)new OutputSupplier<JarOutputStream>(){

            public JarOutputStream getOutput() throws IOException {
                return new JarOutputStream(new FileOutputStream(target));
            }
        });
        JarFile jarFile = new JarFile(target);
        Assert.assertTrue((boolean)jarFile.getJarEntry("subdir/").isDirectory());
        JarEntry jarEntry = jarFile.getJarEntry("subdir/file1");
        Assert.assertNotNull((Object)jarEntry);
        try (InputStreamReader reader = new InputStreamReader(jarFile.getInputStream(jarEntry), Charsets.UTF_8);){
            Assert.assertEquals((Object)message, (Object)CharStreams.toString((Readable)reader));
        }
    }

    private void testNumFiles(int numFiles, boolean isFile) throws IOException {
        File input = isFile ? File.createTempFile("abcd", "txt", TEMP_FOLDER.newFolder()) : TEMP_FOLDER.newFolder();
        ArrayList<File> files = new ArrayList<File>();
        if (!isFile) {
            for (int i = 0; i < numFiles; ++i) {
                files.add(File.createTempFile("abcd", "txt", input));
            }
        } else {
            files.add(input);
        }
        File destArchive = new File(TEMP_FOLDER.newFolder(), "myBundle.jar");
        BundleJarUtil.createJar((File)input, (File)destArchive);
        for (File file : files) {
            ((InputStream)BundleJarUtil.getEntry((Location)Locations.toLocation((File)destArchive), (String)file.getName()).getInput()).close();
        }
    }
}

