/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.io;

import co.cask.cdap.common.io.FileContextLocationFactory;
import co.cask.cdap.common.io.Locations;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileContextLocationFactoryTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private static final String PATH_BASE = "/testing";
    private static MiniDFSCluster dfsCluster;
    private static LocationFactory locationFactory;

    @BeforeClass
    public static void init() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hdfs.minidfs.basedir", TEMP_FOLDER.newFolder().getAbsolutePath());
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        dfsCluster.waitClusterUp();
        locationFactory = new FileContextLocationFactory(dfsCluster.getFileSystem().getConf(), PATH_BASE);
    }

    @AfterClass
    public static void finish() {
        dfsCluster.shutdown();
    }

    @Test
    public void testBasic() throws IOException {
        Assert.assertEquals((Object)locationFactory.create("/file"), (Object)locationFactory.create("/file"));
        Assert.assertEquals((Object)locationFactory.create("/file2"), (Object)locationFactory.create(URI.create(dfsCluster.getFileSystem().getScheme() + ":" + PATH_BASE + "/file2")));
        URI fsURI = dfsCluster.getFileSystem().getUri();
        Assert.assertEquals((Object)locationFactory.create("/file3"), (Object)locationFactory.create(URI.create(String.format("%s://%s/%s/file3", fsURI.getScheme(), fsURI.getAuthority(), PATH_BASE))));
        Assert.assertEquals((Object)locationFactory.create("/"), (Object)locationFactory.create("/"));
        Assert.assertEquals((Object)locationFactory.create("/"), (Object)locationFactory.create(URI.create(dfsCluster.getFileSystem().getScheme() + ":" + PATH_BASE)));
        Assert.assertEquals((Object)locationFactory.create("/"), (Object)locationFactory.create(URI.create(String.format("%s://%s/%s", fsURI.getScheme(), fsURI.getAuthority(), PATH_BASE))));
        Location location = locationFactory.create("/file");
        Assert.assertTrue((boolean)location.createNew());
        Assert.assertTrue((boolean)Locations.getParent((Location)location).isDirectory());
        Location location2 = locationFactory.create("/file2");
        String message = "Testing Message";
        CharStreams.write((CharSequence)message, (OutputSupplier)CharStreams.newWriterSupplier((OutputSupplier)Locations.newOutputSupplier((Location)location2), (Charset)Charsets.UTF_8));
        long length = location2.length();
        long lastModified = location2.lastModified();
        location2.renameTo(location);
        Assert.assertFalse((boolean)location2.exists());
        Assert.assertEquals((Object)message, (Object)CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)Locations.newInputSupplier((Location)location), (Charset)Charsets.UTF_8)));
        Assert.assertEquals((long)length, (long)location.length());
        Assert.assertEquals((long)lastModified, (long)location.lastModified());
    }

    @Test
    public void testList() throws IOException {
        Location dir = locationFactory.create("dir");
        Assert.assertFalse((boolean)dir.isDirectory());
        Assert.assertTrue((boolean)dir.mkdirs());
        Assert.assertTrue((boolean)dir.isDirectory());
        Assert.assertTrue((boolean)dir.list().isEmpty());
        Location file = dir.append("file");
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertTrue((boolean)file.createNew());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertTrue((boolean)file.list().isEmpty());
        List listing = dir.list();
        Assert.assertEquals((long)1L, (long)listing.size());
        Assert.assertEquals((Object)file, listing.get(0));
        file.delete();
        Assert.assertTrue((boolean)dir.list().isEmpty());
        try {
            file.list();
            Assert.fail((String)"List should fail on non-exist location.");
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

