/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.utils;

import co.cask.cdap.common.utils.ProjectInfo;
import org.junit.Assert;
import org.junit.Test;

public class ProjectInfoTest {
    @Test
    public void testInfo() {
        Assert.assertTrue((ProjectInfo.getVersion().getMajor() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ProjectInfo.getVersion().getBuildTime() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testVersion() {
        ProjectInfo.Version version = new ProjectInfo.Version("2.1.0-SNAPSHOT-12345");
        Assert.assertEquals((long)2L, (long)version.getMajor());
        Assert.assertEquals((long)1L, (long)version.getMinor());
        Assert.assertEquals((long)0L, (long)version.getFix());
        Assert.assertTrue((boolean)version.isSnapshot());
        Assert.assertEquals((long)12345L, (long)version.getBuildTime());
        Assert.assertEquals((Object)"2.1.0-SNAPSHOT-12345", (Object)version.toString());
    }

    @Test
    public void testVersionCompare() {
        ProjectInfo.Version version1 = new ProjectInfo.Version("2.1.0-SNAPSHOT-12345");
        ProjectInfo.Version version2 = new ProjectInfo.Version("3.0.0-SNAPSHOT-12345");
        Assert.assertTrue((version1.compareTo(version1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) > 0 ? 1 : 0) != 0);
        version1 = new ProjectInfo.Version("2.0.0-SNAPSHOT-12345");
        version2 = new ProjectInfo.Version("2.1.0-SNAPSHOT-12345");
        Assert.assertTrue((version1.compareTo(version1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) > 0 ? 1 : 0) != 0);
        version1 = new ProjectInfo.Version("2.1.0-SNAPSHOT-12345");
        version2 = new ProjectInfo.Version("2.1.1-SNAPSHOT-12345");
        Assert.assertTrue((version1.compareTo(version1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) > 0 ? 1 : 0) != 0);
        version1 = new ProjectInfo.Version("2.1.0-SNAPSHOT-12345");
        version2 = new ProjectInfo.Version("2.1.0-12345");
        Assert.assertTrue((version1.compareTo(version1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) > 0 ? 1 : 0) != 0);
        version1 = new ProjectInfo.Version("2.1.0-12345");
        version2 = new ProjectInfo.Version("2.1.0-12346");
        Assert.assertTrue((version1.compareTo(version1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) > 0 ? 1 : 0) != 0);
        version1 = new ProjectInfo.Version("2.1.0-SNAPSHOT-12345");
        version2 = new ProjectInfo.Version("2.1.0-SNAPSHOT-12346");
        Assert.assertTrue((version1.compareTo(version1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) > 0 ? 1 : 0) != 0);
    }
}

