/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.lang.jar;

import co.cask.cdap.common.lang.jar.JarResources;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JarResourcesTest {
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testGetResource() throws IOException {
        File jarFile = this.createJar(tmpFolder.newFile());
        Location jarLocation = new LocalLocationFactory(jarFile.getParentFile()).create(jarFile.toURI());
        String classPath = JarResourcesTest.class.getName().replace('.', '/') + ".class";
        JarResources jarResources = new JarResources(jarLocation);
        Assert.assertFalse((boolean)jarResources.contains("test"));
        Assert.assertTrue((boolean)jarResources.contains("logback-test.xml"));
        Assert.assertTrue((boolean)jarResources.contains(classPath));
        Assert.assertArrayEquals((byte[])ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("logback-test.xml")), (byte[])jarResources.getResource("logback-test.xml"));
        Assert.assertArrayEquals((byte[])ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(classPath)), (byte[])jarResources.getResource(classPath));
        Assert.assertArrayEquals((byte[])ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("logback-test.xml")), (byte[])ByteStreams.toByteArray((InputStream)jarResources.getResourceAsStream("logback-test.xml")));
        Assert.assertArrayEquals((byte[])ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(classPath)), (byte[])ByteStreams.toByteArray((InputStream)jarResources.getResourceAsStream(classPath)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createJar(File target) throws IOException {
        try (JarOutputStream jarOutput = new JarOutputStream(new FileOutputStream(target));){
            jarOutput.putNextEntry(new JarEntry("logback-test.xml"));
            ByteStreams.copy((InputStream)this.getClass().getClassLoader().getResourceAsStream("logback-test.xml"), (OutputStream)jarOutput);
            String classPath = JarResourcesTest.class.getName().replace('.', '/') + ".class";
            jarOutput.putNextEntry(new JarEntry(classPath));
            ByteStreams.copy((InputStream)this.getClass().getClassLoader().getResourceAsStream(classPath), (OutputStream)jarOutput);
            File file = target;
            return file;
        }
    }
}

