/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.options;

import co.cask.cdap.common.options.DuplicateOptionException;
import co.cask.cdap.common.options.IllegalOptionValueException;
import co.cask.cdap.common.options.Option;
import co.cask.cdap.common.options.OptionsParser;
import co.cask.cdap.common.options.UnrecognizedOptionException;
import co.cask.cdap.common.options.UnsupportedOptionTypeException;
import co.cask.cdap.common.utils.OSDetector;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class OptionsParserTest {
    @Test
    public void testParse() {
        MyFlags myFlags = new MyFlags();
        String[] args = new String[]{"nonFlagArg1", "--flagNoValue", "-flagOneDashBoolean=false", "nonFlagArg2", "--flagFloat=-10.234", "--flagDouble=0.1", "--flagInt=-3", "--flagShort=10", "--flagLong=123", "--flagString=foo"};
        List nonFlagArgs = OptionsParser.init((Object)myFlags, (String[])args, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertTrue((boolean)myFlags.getFlagNoValue());
        Assert.assertFalse((boolean)myFlags.getFlagOneDashBoolean());
        Assert.assertEquals((float)-10.234f, (float)myFlags.getFlagFloat(), (float)1.0E-4f);
        Assert.assertEquals((double)0.1, (double)myFlags.flagDouble, (double)1.0E-4f);
        Assert.assertEquals((long)-3L, (long)myFlags.flagInt);
        Assert.assertEquals((long)10L, (long)myFlags.flagShort);
        Assert.assertEquals((long)123L, (long)myFlags.flagLong);
        Assert.assertTrue((boolean)myFlags.flagString.equals("foo"));
        Assert.assertTrue((boolean)myFlags.flagDefault.equals("defaultValue"));
        Assert.assertEquals((long)2L, (long)nonFlagArgs.size());
        Assert.assertTrue((boolean)((String)nonFlagArgs.get(0)).equals("nonFlagArg1"));
        Assert.assertTrue((boolean)((String)nonFlagArgs.get(1)).equals("nonFlagArg2"));
    }

    @Test
    public void testUnrecognizedFlag() {
        MyFlags myFlags = new MyFlags();
        String[] args = new String[]{"nonFlagArg1", "--flagNoValue", "-flagOneDashBoolean=false", "nonFlagArg2", "--flagFloat=-10.234", "--notAFlag=foo"};
        try {
            OptionsParser.init((Object)myFlags, (String[])args, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
            Assert.assertTrue((boolean)false);
        }
        catch (UnrecognizedOptionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("notAFlag"));
        }
    }

    @Test
    public void testUnsupportedFlagType() {
        UnsupportedTypeFlags myFlags = new UnsupportedTypeFlags();
        String[] args = new String[]{"--unsupportedFlagType=null"};
        try {
            OptionsParser.init((Object)myFlags, (String[])args, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
            Assert.assertTrue((boolean)false);
        }
        catch (UnsupportedOptionTypeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("unsupportedFlagType"));
        }
    }

    @Test
    public void testIllegalFlagValue() {
        MyFlags myFlags = new MyFlags();
        String[] args = new String[]{"--flagFloat=notANumber"};
        try {
            OptionsParser.init((Object)myFlags, (String[])args, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalOptionValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("flagFloat"));
        }
    }

    @Test
    public void testHexInt() {
        MyFlags myFlags = new MyFlags();
        String[] args = new String[]{"--flagInt=0xA"};
        try {
            OptionsParser.init((Object)myFlags, (String[])args, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalOptionValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("flagInt"));
        }
    }

    @Test
    public void testNoEqualsSeparator() {
        MyFlags myFlags = new MyFlags();
        String[] args = new String[]{"--flagInt", "5"};
        try {
            OptionsParser.init((Object)myFlags, (String[])args, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalOptionValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("flagInt"));
        }
    }

    @Test
    public void testDuplicateFlags() {
        DuplicateFlagDeclaration myFlags = new DuplicateFlagDeclaration();
        try {
            OptionsParser.init((Object)myFlags, (String[])new String[0], (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
            Assert.assertTrue((boolean)false);
        }
        catch (DuplicateOptionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("myFlag"));
        }
    }

    @Test
    public void testHelpOverride() {
        HelpOverride myFlags = new HelpOverride();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OptionsParser.init((Object)myFlags, (String[])new String[]{"--help", "--foo=bar"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)new PrintStream(out));
        Assert.assertTrue((boolean)out.toString().isEmpty());
        Assert.assertTrue((boolean)myFlags.help);
        Assert.assertTrue((boolean)myFlags.foo.equals("bar"));
    }

    @Test
    public void testIgnoreAfterDoubleDashMarker() {
        MyFlags myFlags = new MyFlags();
        OptionsParser.init((Object)myFlags, (String[])new String[]{"--flagInt=7", "--", "--flagDefault=foo"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertEquals((long)7L, (long)myFlags.flagInt);
        Assert.assertEquals((Object)"defaultValue", (Object)myFlags.flagDefault);
    }

    @Test
    public void testKeepLatestFlag() {
        MyFlags myFlags = new MyFlags();
        OptionsParser.init((Object)myFlags, (String[])new String[]{"--flagInt=7", "--flagInt=8"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertEquals((long)8L, (long)myFlags.flagInt);
    }

    @Test
    public void testSubclassedFlags() {
        MySubclassedFlags myFlags = new MySubclassedFlags();
        Assert.assertNotNull((Object)OptionsParser.init((Object)myFlags, (String[])new String[]{"--flagInt=7", "--flagSubclass=foo"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out));
        Assert.assertEquals((long)7L, (long)myFlags.flagInt);
        Assert.assertEquals((Object)"foo", (Object)myFlags.flagSubclass);
    }

    @Test
    public void testEnvVarFlags() {
        if (OSDetector.isWindows()) {
            return;
        }
        MyFlags myFlags = new MyFlags();
        OptionsParser.init((Object)myFlags, (String[])new String[]{"--flagInt=7"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertTrue((boolean)myFlags.homeVar.startsWith("/"));
        myFlags = new MyFlags();
        OptionsParser.init((Object)myFlags, (String[])new String[]{"--home=meep"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertEquals((Object)"meep", (Object)myFlags.homeVar);
        myFlags = new MyFlags();
        OptionsParser.init((Object)myFlags, (String[])new String[]{"--missing=wombat"}, (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertEquals((Object)"wombat", (Object)myFlags.missingEnv);
        myFlags = new MyFlags();
        OptionsParser.init((Object)myFlags, (String[])new String[0], (String)"OptionsParserTest", (String)"0.1.0", (PrintStream)System.out);
        Assert.assertEquals((Object)"missing", (Object)myFlags.missingEnv);
    }

    private static class HelpOverride {
        @Option
        public boolean help;
        @Option
        public String foo;

        private HelpOverride() {
        }
    }

    private static class DuplicateFlagDeclaration {
        @Option
        private int myFlag;
        @Option(name="myFlag")
        private String myDuplicateFlag;

        private DuplicateFlagDeclaration() {
        }
    }

    private static class UnsupportedTypeFlags {
        @Option
        private Object unsupportedFlagType;

        private UnsupportedTypeFlags() {
        }
    }

    private static class MySubclassedFlags
    extends MyFlags {
        @Option
        public String flagSubclass;

        private MySubclassedFlags() {
        }
    }

    private static class MyFlags {
        @Option(usage="a boolean flag")
        private boolean flagNoValue;
        @Option
        protected boolean flagOneDashBoolean;
        @Option(name="flagFloat")
        public float flagNumber;
        @Option
        public double flagDouble;
        @Option
        public int flagInt;
        @Option
        public long flagLong;
        @Option
        public short flagShort;
        @Option
        public String flagString;
        @Option
        public String flagDefault = "defaultValue";
        @Option(name="home", envVar="HOME", hidden=true)
        public String homeVar = "somedefault";
        @Option(name="missing", envVar="MISSING_ENV_VAR_XXXXXXX", hidden=true)
        public String missingEnv = "missing";
        private String notAFlag;

        private MyFlags() {
        }

        public boolean getFlagNoValue() {
            return this.flagNoValue;
        }

        public boolean getFlagOneDashBoolean() {
            return this.flagOneDashBoolean;
        }

        public float getFlagFloat() {
            return this.flagNumber;
        }
    }
}

