/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.namespace;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.namespace.DefaultNamespacedLocationFactory;
import co.cask.cdap.proto.Id;
import java.io.IOException;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DefaultNamespacedLocationFactoryTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();

    @Test
    public void testGet() throws IOException {
        LocalLocationFactory locationFactory = new LocalLocationFactory(TEMP_FOLDER.newFolder());
        DefaultNamespacedLocationFactory namespacedLocationFactory = new DefaultNamespacedLocationFactory(CConfiguration.create(), (LocationFactory)locationFactory);
        Location defaultLoc = namespacedLocationFactory.get(Id.Namespace.DEFAULT);
        Id.Namespace ns1 = Id.Namespace.from((String)"ns1");
        Location ns1Loc = namespacedLocationFactory.get(ns1);
        Assert.assertNotEquals((Object)defaultLoc, (Object)ns1Loc);
        Location sub1 = namespacedLocationFactory.get(ns1, "sub1");
        Location sub2 = namespacedLocationFactory.get(ns1, "sub2");
        Assert.assertNotEquals((Object)sub1, (Object)sub2);
    }
}

