/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.lang;

import co.cask.cdap.api.app.Application;
import co.cask.cdap.common.lang.ClassLoaders;
import co.cask.cdap.common.lang.FilterClassLoader;
import java.io.IOException;
import javax.ws.rs.PUT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class FilterClassLoaderTest {
    @Test(expected=ClassNotFoundException.class)
    public void testSystemInternalsHidden() throws ClassNotFoundException {
        FilterClassLoader classLoader = FilterClassLoader.create((ClassLoader)this.getClass().getClassLoader());
        classLoader.loadClass(FilterClassLoader.class.getName());
    }

    @Test
    public void testAPIVisible() throws ClassNotFoundException {
        FilterClassLoader classLoader = FilterClassLoader.create((ClassLoader)this.getClass().getClassLoader());
        Assert.assertSame(Application.class, (Object)classLoader.loadClass(Application.class.getName()));
        Assert.assertSame(Logger.class, (Object)classLoader.loadClass(Logger.class.getName()));
        Assert.assertSame(PUT.class, (Object)classLoader.loadClass(PUT.class.getName()));
    }

    @Test
    public void testBootstrapResourcesVisible() throws IOException {
        FilterClassLoader classLoader = FilterClassLoader.create((ClassLoader)this.getClass().getClassLoader());
        Assert.assertNotNull((Object)classLoader.getResource("java/lang/String.class"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHadoopResourcesVisible() throws ClassNotFoundException {
        FilterClassLoader classLoader = FilterClassLoader.create((ClassLoader)this.getClass().getClassLoader());
        ClassLoader oldClassLoader = ClassLoaders.setContextClassLoader((ClassLoader)classLoader);
        try {
            Assert.assertNotEquals((Object)"Unknown", (Object)VersionInfo.getVersion());
        }
        finally {
            ClassLoaders.setContextClassLoader((ClassLoader)oldClassLoader);
        }
        Assert.assertSame(Configuration.class, (Object)classLoader.loadClass(Configuration.class.getName()));
    }
}

