/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.service;

import co.cask.cdap.common.service.RetryOnStartFailureService;
import co.cask.cdap.common.service.RetryStrategies;
import co.cask.cdap.common.service.RetryStrategy;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.twill.common.ServiceListenerAdapter;
import org.apache.twill.common.Threads;
import org.junit.Assert;
import org.junit.Test;

public class RetryOnStartFailureServiceTest {
    @Test
    public void testRetrySucceed() throws InterruptedException {
        CountDownLatch startLatch = new CountDownLatch(1);
        RetryOnStartFailureService service = new RetryOnStartFailureService(this.createServiceSupplier(3, startLatch, new CountDownLatch(1)), RetryStrategies.fixDelay((long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
        service.startAndWait();
        Assert.assertTrue((boolean)startLatch.await(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testRetryFail() throws InterruptedException {
        CountDownLatch startLatch = new CountDownLatch(1);
        RetryOnStartFailureService service = new RetryOnStartFailureService(this.createServiceSupplier(1000, startLatch, new CountDownLatch(1)), RetryStrategies.limit((int)10, (RetryStrategy)RetryStrategies.fixDelay((long)10L, (TimeUnit)TimeUnit.MILLISECONDS)));
        final CountDownLatch failureLatch = new CountDownLatch(1);
        service.addListener((Service.Listener)new ServiceListenerAdapter(){

            public void failed(Service.State from, Throwable failure) {
                failureLatch.countDown();
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        service.start();
        Assert.assertTrue((boolean)failureLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)startLatch.await(100L, TimeUnit.MILLISECONDS));
    }

    @Test(timeout=5000L)
    public void testFailureStop() throws InterruptedException {
        CountDownLatch failureLatch = new CountDownLatch(1);
        RetryOnStartFailureService service = new RetryOnStartFailureService(this.createServiceSupplier(1000, new CountDownLatch(1), failureLatch), RetryStrategies.fixDelay((long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
        service.startAndWait();
        Assert.assertTrue((boolean)failureLatch.await(1L, TimeUnit.SECONDS));
        service.stopAndWait();
    }

    private Supplier<Service> createServiceSupplier(final int startFailures, final CountDownLatch startLatch, final CountDownLatch failureLatch) {
        return new Supplier<Service>(){
            private int failures = 0;

            public Service get() {
                return new AbstractIdleService(){

                    protected void startUp() throws Exception {
                        if (failures++ < startFailures) {
                            failureLatch.countDown();
                            throw new RuntimeException("Fail");
                        }
                        startLatch.countDown();
                    }

                    protected void shutDown() throws Exception {
                    }
                };
            }
        };
    }
}

