/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.kerberos;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.kerberos.SecurityUtil;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;

public class SecurityUtilTest {
    @Test
    public void testExpandPrincipal() throws Exception {
        String localHostname = InetAddress.getLocalHost().getCanonicalHostName();
        Assert.assertNull((Object)SecurityUtil.expandPrincipal(null));
        Assert.assertEquals((Object)("user/" + localHostname + "@REALM.NET"), (Object)SecurityUtil.expandPrincipal((String)"user/_HOST@REALM.NET"));
        Assert.assertEquals((Object)"user/abc.com@REALM.NET", (Object)SecurityUtil.expandPrincipal((String)"user/abc.com@REALM.NET"));
        Assert.assertEquals((Object)"_HOST/abc.com@REALM.NET", (Object)SecurityUtil.expandPrincipal((String)"_HOST/abc.com@REALM.NET"));
        Assert.assertEquals((Object)("_HOST/" + localHostname + "@REALM.NET"), (Object)SecurityUtil.expandPrincipal((String)"_HOST/_HOST@REALM.NET"));
        Assert.assertEquals((Object)"user/_host@REALM.NET", (Object)SecurityUtil.expandPrincipal((String)"user/_host@REALM.NET"));
    }

    @Test
    public void isKerberosEnabled() throws Exception {
        CConfiguration kerbConf = CConfiguration.create();
        kerbConf.set("kerberos.auth.enabled", "true");
        kerbConf.set("cdap.master.kerberos.principal", "prinicpal@REALM.NET");
        kerbConf.set("cdap.master.kerberos.keytab", "/path/to/keytab");
        Assert.assertTrue((boolean)SecurityUtil.isKerberosEnabled((CConfiguration)kerbConf));
        CConfiguration noPrincipalConf = CConfiguration.create();
        kerbConf.set("kerberos.auth.enabled", "false");
        noPrincipalConf.unset("cdap.master.kerberos.principal");
        noPrincipalConf.set("cdap.master.kerberos.keytab", "/path/to/keytab");
        Assert.assertFalse((boolean)SecurityUtil.isKerberosEnabled((CConfiguration)noPrincipalConf));
        CConfiguration noKeyTabConf = CConfiguration.create();
        kerbConf.set("kerberos.auth.enabled", "false");
        noKeyTabConf.unset("cdap.master.kerberos.keytab");
        noKeyTabConf.set("cdap.master.kerberos.principal", "prinicpal@REALM.NET");
        Assert.assertFalse((boolean)SecurityUtil.isKerberosEnabled((CConfiguration)noKeyTabConf));
    }
}

