/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.common.conf.CConfiguration;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class CConfigurationTest {
    private static final String DEPRECATED_PROPERTY_VALUE = "Value of deprecated property";

    @Test
    public void testConfiguration() throws Exception {
        CConfiguration conf = CConfiguration.create();
        String a = conf.get("conf.test.A");
        String b = conf.get("conf.test.B");
        Assert.assertNull((Object)a);
        Assert.assertNull((Object)b);
        conf.addResource("test-default.xml");
        a = conf.get("conf.test.A");
        b = conf.get("conf.test.B");
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((Object)"A", (Object)a);
        Assert.assertEquals((Object)"B", (Object)b);
        conf.addResource("test-override.xml");
        a = conf.get("conf.test.A");
        b = conf.get("conf.test.B");
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((Object)"A", (Object)a);
        Assert.assertEquals((Object)"B+", (Object)b);
    }

    @Test
    public void testAddedConfiguration() throws Exception {
        CConfiguration conf = CConfiguration.create();
        conf.addResource("test-default.xml");
        conf.set("conf.test.addedA", "AddedA");
        conf.set("conf.test.addedB", "AddedB");
        conf.set("conf.test.A", "A+");
        Assert.assertNotNull((Object)conf.get("conf.test.A"));
        Assert.assertNotNull((Object)conf.get("conf.test.B"));
        Assert.assertNotNull((Object)conf.get("conf.test.addedA"));
        Assert.assertNotNull((Object)conf.get("conf.test.addedB"));
        Assert.assertEquals((Object)"A+", (Object)conf.get("conf.test.A"));
        Assert.assertEquals((Object)"AddedA", (Object)conf.get("conf.test.addedA"));
        Assert.assertEquals((Object)"AddedB", (Object)conf.get("conf.test.addedB"));
    }

    @Test
    public void testMissingConfigProperties() throws Exception {
        CConfiguration conf = CConfiguration.create();
        conf.setInt("test.property.int", 1);
        conf.setLong("test.property.long", 1L);
        conf.set("test.property.longbytes", "1k");
        conf.setFloat("test.property.float", 1.1f);
        conf.set("test.property.boolean", "true");
        conf.set("test.property.enum", TestEnum.FIRST.name());
        String testRegex = ".*";
        conf.set("test.property.pattern", testRegex);
        try {
            conf.getInt("missing.property");
            Assert.fail((String)"Expected getInt() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)conf.getInt("test.property.int"));
        try {
            conf.getLong("missing.property");
            Assert.fail((String)"Expected getLong() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)conf.getLong("test.property.long"));
        try {
            conf.getLongBytes("missing.property");
            Assert.fail((String)"Expected getLongBytes() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1024L, (long)conf.getLongBytes("test.property.longbytes"));
        try {
            conf.getFloat("missing.property");
            Assert.fail((String)"Expected getFloat() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((float)1.1f, (float)conf.getFloat("test.property.float"), (float)0.01f);
        try {
            conf.getBoolean("missing.property");
            Assert.fail((String)"Expected getBoolean() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("test.property.boolean"));
        try {
            conf.getEnum("missing.property", TestEnum.class);
            Assert.fail((String)"Expected getEnum() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)TestEnum.FIRST), (Object)conf.getEnum("test.property.enum", TestEnum.class));
        try {
            conf.getPattern("missing.property");
            Assert.fail((String)"Expected getPattern() to throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)testRegex, (Object)conf.getPattern("test.property.pattern").pattern());
        try {
            conf.getRange("missing.property");
            Assert.fail((String)"Expected getRange() to throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testDeprecatedConfigProperties() throws Exception {
        CConfiguration conf = CConfiguration.create();
        Map deprecated = conf.getDeprecatedProps();
        if (!deprecated.isEmpty()) {
            Map.Entry property = deprecated.entrySet().iterator().next();
            ByteArrayInputStream resource = new ByteArrayInputStream(Bytes.toBytes((String)String.format("<configuration><property><name>%s</name><value>%s</value></property></configuration>", property.getKey(), DEPRECATED_PROPERTY_VALUE)));
            conf.addResource((InputStream)resource);
            conf.reloadConfiguration();
            for (String newProperty : (String[])property.getValue()) {
                Assert.assertEquals((Object)DEPRECATED_PROPERTY_VALUE, (Object)conf.get(newProperty));
            }
            conf.clear();
            conf.set((String)property.getKey(), DEPRECATED_PROPERTY_VALUE);
            for (String newProperty : (String[])property.getValue()) {
                Assert.assertEquals((Object)DEPRECATED_PROPERTY_VALUE, (Object)conf.get(newProperty));
            }
            Closeables.closeQuietly((Closeable)resource);
        }
    }

    private static enum TestEnum {
        FIRST;

    }
}

