/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import co.cask.cdap.internal.io.ReflectionSchemaGenerator;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class SchemaTest {
    @Test
    public void testGenerateSchema() throws UnsupportedTypeException {
        Schema schema = new ReflectionSchemaGenerator().generate(new TypeToken<Child<Node>>(){}.getType());
        Gson gson = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).create();
        Assert.assertEquals((Object)schema, (Object)gson.fromJson(gson.toJson((Object)schema), Schema.class));
    }

    @Test
    public void testSchemaHash() throws UnsupportedTypeException {
        Schema s1 = new ReflectionSchemaGenerator().generate(Node.class);
        Schema s2 = new ReflectionSchemaGenerator().generate(Node2.class);
        Assert.assertEquals((Object)s1.getSchemaHash(), (Object)s2.getSchemaHash());
        Assert.assertEquals((Object)s1, (Object)s2);
        Schema schema = new ReflectionSchemaGenerator().generate(new TypeToken<Child<Node>>(){}.getType());
        Assert.assertNotEquals((Object)s1.getSchemaHash(), (Object)schema.getSchemaHash());
    }

    @Test
    public void testCompatible() throws UnsupportedTypeException {
        Schema s1 = new ReflectionSchemaGenerator().generate(Node.class);
        Schema s2 = new ReflectionSchemaGenerator().generate(Node3.class);
        Schema s3 = new ReflectionSchemaGenerator().generate(Node4.class);
        Assert.assertNotEquals((Object)s1, (Object)s2);
        Assert.assertTrue((boolean)s1.isCompatible(s2));
        Assert.assertFalse((boolean)s2.isCompatible(s1));
        Assert.assertTrue((boolean)s2.isCompatible(s3));
    }

    @Test
    public void testPrimitiveArray() throws UnsupportedTypeException {
        Schema schema = new ReflectionSchemaGenerator().generate(int[].class);
        Assert.assertEquals((Object)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.INT)), (Object)schema);
    }

    @Test
    public void testParseJson() throws IOException, UnsupportedTypeException {
        Schema schema = new ReflectionSchemaGenerator().generate(Node.class);
        Assert.assertEquals((Object)schema, (Object)Schema.parseJson((String)schema.toString()));
    }

    @Test
    public void testParseFlatSQL() throws IOException {
        String schemaStr = "bool_field boolean, int_field int not null, long_field long not null, float_field float NOT NULL, double_field double NOT NULL, bytes_field bytes not null, array_field array<string> not null, map_field map<string,int> not null, record_field record<x:int,y:double>, string_field string";
        Schema expected = Schema.recordOf((String)"rec", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"bool_field", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.BOOLEAN))), Schema.Field.of((String)"int_field", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"long_field", (Schema)Schema.of((Schema.Type)Schema.Type.LONG)), Schema.Field.of((String)"float_field", (Schema)Schema.of((Schema.Type)Schema.Type.FLOAT)), Schema.Field.of((String)"double_field", (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)), Schema.Field.of((String)"bytes_field", (Schema)Schema.of((Schema.Type)Schema.Type.BYTES)), Schema.Field.of((String)"array_field", (Schema)Schema.arrayOf((Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING)))), Schema.Field.of((String)"map_field", (Schema)Schema.mapOf((Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING)), (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT)))), Schema.Field.of((String)"record_field", (Schema)Schema.nullableOf((Schema)Schema.recordOf((String)"rec1", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"y", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)))}))), Schema.Field.of((String)"string_field", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING)))});
        Assert.assertEquals((Object)expected, (Object)Schema.parseSQL((String)schemaStr));
    }

    @Test
    public void testNestedSQL() throws IOException {
        Schema expected = Schema.recordOf((String)"rec", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (Schema)Schema.mapOf((Schema)Schema.recordOf((String)"rec1", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"y", (Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"z", (Schema)Schema.mapOf((Schema)Schema.of((Schema.Type)Schema.Type.BYTES), (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)))}), (Schema)Schema.arrayOf((Schema)Schema.recordOf((String)"rec2", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (Schema)Schema.mapOf((Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.BYTES)), (Schema)Schema.mapOf((Schema)Schema.of((Schema.Type)Schema.Type.BOOLEAN), (Schema)Schema.of((Schema.Type)Schema.Type.BYTES))))})))), Schema.Field.of((String)"y", (Schema)Schema.of((Schema.Type)Schema.Type.INT))});
        String schemaStr = "x map<record<x:string not null,y:array<string not null> not null,z:map<bytes not null,double not null> not null> not null,array<record<x:map<array<bytes not null> not null,map<boolean not null,bytes not null> not null> not null> not null> not null> not null, y int not null";
        Assert.assertEquals((Object)expected, (Object)Schema.parseSQL((String)schemaStr));
    }

    @Test
    public void testParseSQLWithWhitespace() throws IOException {
        String schemaStr = "map_field map< string , int >   not null,\narr_field array< record< x:int , y:double >\t> not null";
        Schema expectedSchema = Schema.recordOf((String)"rec", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"map_field", (Schema)Schema.mapOf((Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING)), (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT)))), Schema.Field.of((String)"arr_field", (Schema)Schema.arrayOf((Schema)Schema.nullableOf((Schema)Schema.recordOf((String)"rec1", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"x", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"y", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)))}))))});
        Assert.assertEquals((Object)expectedSchema, (Object)Schema.parseSQL((String)schemaStr));
    }

    @Test
    public void testInvalidSQL() {
        this.verifyThrowsException("int x");
        this.verifyThrowsException("x map<int, int");
        this.verifyThrowsException("x array<string");
        this.verifyThrowsException("x bool");
        this.verifyThrowsException("x integer");
        this.verifyThrowsException("x record<y int>");
        this.verifyThrowsException("x array<>");
    }

    private void verifyThrowsException(String toParse) {
        try {
            Schema.parseSQL((String)toParse);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final class Node4 {
        private String data;
    }

    public final class Node3 {
        private long data;
        private String tag;
        private List<Node3> children;
    }

    public final class Node2 {
        private int data;
        private List<Node2> children;
    }

    public static enum State {
        OK,
        ERROR;

    }

    public class Child<T>
    extends Parent<Map<String, T>> {
        private int height;
        private Node rootNode;
        private State state;
    }

    public class Parent<T> {
        private T data;
        private ByteBuffer buffer;
    }

    public final class Node {
        private int data;
        private List<Node> children;
    }
}

