/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.io;

import co.cask.cdap.common.io.BinaryDecoder;
import co.cask.cdap.common.io.BinaryEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.junit.Assert;
import org.junit.Test;

public class CodecTest {
    @Test
    public void testCodec() throws IOException {
        PipedOutputStream output = new PipedOutputStream();
        PipedInputStream input = new PipedInputStream(output);
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)output);
        BinaryDecoder decoder = new BinaryDecoder((InputStream)input);
        encoder.writeNull();
        Assert.assertNull((Object)decoder.readNull());
        encoder.writeBool(true);
        Assert.assertTrue((boolean)decoder.readBool());
        encoder.writeBool(false);
        Assert.assertFalse((boolean)decoder.readBool());
        encoder.writeInt(0);
        Assert.assertEquals((long)0L, (long)decoder.readInt());
        encoder.writeInt(-1);
        Assert.assertEquals((long)-1L, (long)decoder.readInt());
        encoder.writeInt(1234);
        Assert.assertEquals((long)1234L, (long)decoder.readInt());
        encoder.writeInt(-1234);
        Assert.assertEquals((long)-1234L, (long)decoder.readInt());
        encoder.writeInt(Short.MAX_VALUE);
        Assert.assertEquals((long)32767L, (long)decoder.readInt());
        encoder.writeInt(Short.MIN_VALUE);
        Assert.assertEquals((long)-32768L, (long)decoder.readInt());
        encoder.writeInt(Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)decoder.readInt());
        encoder.writeInt(Integer.MIN_VALUE);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)decoder.readInt());
        encoder.writeLong(0L);
        Assert.assertEquals((long)0L, (long)decoder.readLong());
        encoder.writeLong(-20L);
        Assert.assertEquals((long)-20L, (long)decoder.readLong());
        encoder.writeLong(30000L);
        Assert.assertEquals((long)30000L, (long)decoder.readLong());
        encoder.writeLong(-600000L);
        Assert.assertEquals((long)-600000L, (long)decoder.readLong());
        encoder.writeLong(Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)decoder.readLong());
        encoder.writeLong(Integer.MIN_VALUE);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)decoder.readLong());
        encoder.writeLong(Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)decoder.readLong());
        encoder.writeLong(Long.MIN_VALUE);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)decoder.readLong());
        encoder.writeFloat(3.14f);
        Assert.assertEquals((float)3.14f, (float)decoder.readFloat(), (float)1.0E-7f);
        encoder.writeFloat(32767.0f);
        Assert.assertEquals((float)32767.0f, (float)decoder.readFloat(), (float)1.0E-7f);
        encoder.writeFloat(-2.1474836E9f);
        Assert.assertEquals((float)-2.1474836E9f, (float)decoder.readFloat(), (float)1.0E-7f);
        encoder.writeFloat(7.0366597E13f);
        Assert.assertEquals((float)7.0366597E13f, (float)decoder.readFloat(), (float)1.0E-7f);
        encoder.writeFloat(Float.MAX_VALUE);
        Assert.assertEquals((float)Float.MAX_VALUE, (float)decoder.readFloat(), (float)1.0E-7f);
        encoder.writeFloat(Float.MIN_VALUE);
        Assert.assertEquals((float)Float.MIN_VALUE, (float)decoder.readFloat(), (float)1.0E-7f);
        encoder.writeDouble(Math.E);
        Assert.assertEquals((double)Math.E, (double)decoder.readDouble(), (double)1.0E-7f);
        encoder.writeDouble(2.147483647E9);
        Assert.assertEquals((double)2.147483647E9, (double)decoder.readDouble(), (double)1.0E-7f);
        encoder.writeDouble(-9.223372036854776E18);
        Assert.assertEquals((double)-9.223372036854776E18, (double)decoder.readDouble(), (double)1.0E-7f);
        encoder.writeDouble(7.0366596661249E13);
        Assert.assertEquals((double)7.0366596661249E13, (double)decoder.readDouble(), (double)1.0E-7f);
        encoder.writeDouble(Double.MAX_VALUE);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)decoder.readDouble(), (double)1.0E-7f);
        encoder.writeDouble(Double.MIN_VALUE);
        Assert.assertEquals((double)Double.MIN_VALUE, (double)decoder.readDouble(), (double)1.0E-7f);
        encoder.writeString("This is a testing message");
        Assert.assertEquals((Object)"This is a testing message", (Object)decoder.readString());
        String str = Character.toString('\u00c8') + Character.toString('\u4e20') + Character.toString('\u9c40');
        encoder.writeString(str);
        Assert.assertEquals((Object)str, (Object)decoder.readString());
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.asIntBuffer().put(10).put(1024).put(9999999);
        encoder.writeBytes(buf);
        IntBuffer inBuf = decoder.readBytes().asIntBuffer();
        Assert.assertEquals((long)10L, (long)inBuf.get());
        Assert.assertEquals((long)1024L, (long)inBuf.get());
        Assert.assertEquals((long)9999999L, (long)inBuf.get());
    }
}

