/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.logging;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.common.logging.LogCollector;
import co.cask.cdap.common.logging.LogEvent;
import co.cask.cdap.common.logging.LogFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LogCollectorTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    String makeMessage(int i) {
        return String.format("This is error message %5d.", i);
    }

    private void testCollection(CConfiguration config, Configuration hConfig) throws IOException {
        int i;
        String logtag = "a:b:c";
        int lengthOfOne = String.format("%s [%s] %s\n", logtag, "ERROR", this.makeMessage(10000)).getBytes(LogFileWriter.CHARSET_UTF8).length;
        config.setInt("logfile.roll.instances", 3);
        config.setInt("logfile.roll.size", 10 * lengthOfOne + 2);
        LogCollector collector = new LogCollector(config, hConfig);
        for (int i2 = 0; i2 < 5; ++i2) {
            collector.log(new LogEvent(logtag, "ERROR", this.makeMessage(i2)));
        }
        List lines = collector.tail(logtag, lengthOfOne + 10);
        Assert.assertEquals((long)1L, (long)lines.size());
        lines = collector.tail(logtag, 3 * lengthOfOne + 10);
        Assert.assertEquals((long)3L, (long)lines.size());
        lines = collector.tail(logtag, 10 * lengthOfOne + 10);
        Assert.assertEquals((long)5L, (long)lines.size());
        LogCollector collector2 = new LogCollector(config, hConfig);
        lines = collector2.tail(logtag, lengthOfOne + 10);
        Assert.assertEquals((long)1L, (long)lines.size());
        for (i = 5; i < 11; ++i) {
            collector.log(new LogEvent(logtag, "ERROR", this.makeMessage(i)));
        }
        lines = collector.tail(logtag, lengthOfOne + 10);
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertTrue((boolean)((String)lines.get(0)).contains(this.makeMessage(10)));
        collector.log(new LogEvent(logtag, "ERROR", this.makeMessage(11)));
        lines = collector.tail(logtag, 2 * lengthOfOne + 10);
        Assert.assertEquals((long)2L, (long)lines.size());
        Assert.assertTrue((boolean)((String)lines.get(0)).contains(this.makeMessage(10)));
        Assert.assertTrue((boolean)((String)lines.get(1)).contains(this.makeMessage(11)));
        for (i = 12; i < 36; ++i) {
            collector.log(new LogEvent(logtag, "ERROR", this.makeMessage(i)));
        }
        lines = collector.tail(logtag, 16 * lengthOfOne + 10);
        Assert.assertEquals((long)16L, (long)lines.size());
        for (i = 0; i < 16; ++i) {
            Assert.assertTrue((boolean)((String)lines.get(i)).contains(this.makeMessage(i + 20)));
        }
        lines = collector.tail(logtag, 27 * lengthOfOne + 10);
        Assert.assertEquals((long)25L, (long)lines.size());
        for (i = 0; i < 25; ++i) {
            Assert.assertTrue((boolean)((String)lines.get(i)).contains(this.makeMessage(i + 11)));
        }
        collector.close();
        collector = new LogCollector(config, hConfig);
        lines = collector.tail(logtag, 27 * lengthOfOne + 10);
        Assert.assertEquals((long)25L, (long)lines.size());
        for (i = 0; i < 25; ++i) {
            Assert.assertTrue((boolean)((String)lines.get(i)).contains(this.makeMessage(i + 11)));
        }
        collector.log(new LogEvent(logtag, "ERROR", this.makeMessage(36)));
        lines = collector.tail(logtag, 27 * lengthOfOne + 10);
        Assert.assertEquals((long)26L, (long)lines.size());
        for (i = 0; i < 26; ++i) {
            Assert.assertTrue((boolean)((String)lines.get(i)).contains(this.makeMessage(i + 11)));
        }
    }

    @Test
    public void testCollectionLocalFS() throws IOException {
        File prefix = this.tempFolder.newFolder();
        CConfiguration config = CConfiguration.create();
        config.set("log.collection.root", prefix.getAbsolutePath());
        Configuration hConf = new Configuration();
        this.testCollection(config, hConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectionDFS() throws IOException {
        MiniDFSCluster dfsCluster = null;
        try {
            File dfsPath = this.tempFolder.newFolder();
            System.setProperty("test.build.data", dfsPath.toString());
            System.setProperty("test.cache.data", dfsPath.toString());
            System.err.println("Starting up Mini HDFS cluster...");
            Configuration hConf = new Configuration();
            CConfiguration conf = CConfiguration.create();
            dfsCluster = new MiniDFSCluster.Builder(hConf).nameNodePort(0).numDataNodes(1).format(true).manageDataDfsDirs(true).manageNameDfsDirs(true).build();
            dfsCluster.waitClusterUp();
            System.err.println("Mini HDFS is started.");
            hConf.set("fs.defaultFS", dfsCluster.getFileSystem().getUri().toString());
            conf.set("log.collection.root", "/logtemp");
            this.testCollection(conf, hConf);
        }
        finally {
            if (dfsCluster != null) {
                System.err.println("Shutting down Mini HDFS cluster...");
                dfsCluster.shutdown();
                System.err.println("Mini HDFS is shut down.");
            }
        }
    }
}

