/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.gateway.handlers;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.gateway.handlers.ConfigService;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class ConfigServiceTest {
    @Test
    public void testConfig() {
        CConfiguration cConf = CConfiguration.create();
        cConf.clear();
        String cConfResourceString = "<configuration>\n\n  <property>\n    <name>stream.zz.threshold</name>\n    <value>1</value>\n    <description>Some description</description>\n  </property>\n\n</configuration>";
        ReaderInputStream cConfResource = new ReaderInputStream((Reader)new StringReader(cConfResourceString));
        cConf.addResource((InputStream)cConfResource);
        ConfigService.ConfigEntry cConfEntry = new ConfigService.ConfigEntry("stream.zz.threshold", "1", cConfResource.toString());
        Configuration hConf = new Configuration();
        String hConfResourceString = "<configuration>\n\n  <property>\n    <name>stream.notification.threshold</name>\n    <value>3</value>\n    <description>Some description</description>\n  </property>\n\n</configuration>";
        ReaderInputStream hConfResource = new ReaderInputStream((Reader)new StringReader(hConfResourceString));
        hConf.addResource((InputStream)hConfResource);
        ConfigService.ConfigEntry hConfEntry = new ConfigService.ConfigEntry("stream.notification.threshold", "3", hConfResource.toString());
        ConfigService configService = new ConfigService(cConf, hConf);
        List cConfEntries = configService.getCConf();
        Assert.assertTrue((boolean)cConfEntries.contains(cConfEntry));
        List hConfEntries = configService.getHConf();
        Assert.assertTrue((boolean)hConfEntries.contains(hConfEntry));
    }
}

