/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.queue;

import co.cask.cdap.common.queue.QueueName;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class QueueNameTest {
    @Test
    public void testQueueNameForFlowlet() {
        QueueName queueName = QueueName.fromFlowlet((String)"namespace", (String)"app", (String)"flow", (String)"flowlet", (String)"out");
        Assert.assertTrue((boolean)queueName.isQueue());
        Assert.assertFalse((boolean)queueName.isStream());
        Assert.assertEquals((Object)"namespace", (Object)queueName.getFirstComponent());
        Assert.assertEquals((Object)"app", (Object)queueName.getSecondComponent());
        Assert.assertEquals((Object)"flow", (Object)queueName.getThirdComponent());
        Assert.assertEquals((Object)"flowlet", (Object)queueName.getFourthComponent());
        Assert.assertEquals((Object)"out", (Object)queueName.getSimpleName());
        queueName = QueueName.from((URI)queueName.toURI());
        Assert.assertTrue((boolean)queueName.isQueue());
        Assert.assertFalse((boolean)queueName.isStream());
        Assert.assertEquals((Object)"namespace", (Object)queueName.getFirstComponent());
        Assert.assertEquals((Object)"app", (Object)queueName.getSecondComponent());
        Assert.assertEquals((Object)"flow", (Object)queueName.getThirdComponent());
        Assert.assertEquals((Object)"flowlet", (Object)queueName.getFourthComponent());
        Assert.assertEquals((Object)"out", (Object)queueName.getSimpleName());
        queueName = QueueName.from((byte[])queueName.toBytes());
        Assert.assertTrue((boolean)queueName.isQueue());
        Assert.assertFalse((boolean)queueName.isStream());
        Assert.assertEquals((Object)"namespace", (Object)queueName.getFirstComponent());
        Assert.assertEquals((Object)"app", (Object)queueName.getSecondComponent());
        Assert.assertEquals((Object)"flow", (Object)queueName.getThirdComponent());
        Assert.assertEquals((Object)"flowlet", (Object)queueName.getFourthComponent());
        Assert.assertEquals((Object)"out", (Object)queueName.getSimpleName());
        Assert.assertEquals((Object)"queue:///namespace/", (Object)QueueName.prefixForNamespacedQueue((String)"namespace"));
        Assert.assertEquals((Object)"queue:///namespace/app/flow/", (Object)QueueName.prefixForFlow((String)"namespace", (String)"app", (String)"flow"));
    }

    @Test
    public void testQueueNameForStream() {
        QueueName queueName = QueueName.fromStream((String)"fooNamespace", (String)"mystream");
        this.verifyStreamName(queueName, "fooNamespace", "mystream");
        queueName = QueueName.fromStream((String)"otherNamespace", (String)"audi_test_stream");
        this.verifyStreamName(queueName, "otherNamespace", "audi_test_stream");
        queueName = QueueName.fromStream((String)"barSpace", (String)"audi_-test_stream");
        this.verifyStreamName(queueName, "barSpace", "audi_-test_stream");
    }

    private void verifyStreamName(QueueName queueName, String namespace, String streamName) {
        Assert.assertFalse((boolean)queueName.isQueue());
        Assert.assertTrue((boolean)queueName.isStream());
        Assert.assertEquals((Object)namespace, (Object)queueName.getFirstComponent());
        Assert.assertEquals((Object)streamName, (Object)queueName.getSecondComponent());
        Assert.assertNull((Object)queueName.getThirdComponent());
        Assert.assertNull((Object)queueName.getFourthComponent());
        Assert.assertEquals((Object)streamName, (Object)queueName.getSimpleName());
        queueName = QueueName.from((URI)queueName.toURI());
        Assert.assertFalse((boolean)queueName.isQueue());
        Assert.assertTrue((boolean)queueName.isStream());
        Assert.assertEquals((Object)namespace, (Object)queueName.getFirstComponent());
        Assert.assertEquals((Object)streamName, (Object)queueName.getSecondComponent());
        Assert.assertNull((Object)queueName.getThirdComponent());
        Assert.assertNull((Object)queueName.getFourthComponent());
        Assert.assertEquals((Object)streamName, (Object)queueName.getSimpleName());
        queueName = QueueName.from((byte[])queueName.toBytes());
        Assert.assertFalse((boolean)queueName.isQueue());
        Assert.assertTrue((boolean)queueName.isStream());
        Assert.assertEquals((Object)namespace, (Object)queueName.getFirstComponent());
        Assert.assertEquals((Object)streamName, (Object)queueName.getSecondComponent());
        Assert.assertNull((Object)queueName.getThirdComponent());
        Assert.assertNull((Object)queueName.getFourthComponent());
        Assert.assertEquals((Object)streamName, (Object)queueName.getSimpleName());
    }
}

