/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.streamevent;

import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.common.stream.StreamEventTypeAdapter;
import com.google.common.base.Charsets;
import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class StreamEventTypeAdapterTest {
    private static final Equivalence<StreamEvent> STREAM_EVENT_EQUIVALENCE = new Equivalence<StreamEvent>(){

        protected boolean doEquivalent(StreamEvent a, StreamEvent b) {
            return Objects.equal((Object)a.getTimestamp(), (Object)b.getTimestamp()) && Objects.equal((Object)a.getHeaders(), (Object)b.getHeaders()) && Objects.equal((Object)a.getBody(), (Object)b.getBody());
        }

        protected int doHash(StreamEvent streamEvent) {
            return Objects.hashCode((Object[])new Object[]{streamEvent.getTimestamp(), streamEvent.getHeaders(), streamEvent.getBody()});
        }
    };

    @Test
    public void testAdapter() throws IOException {
        Gson gson = StreamEventTypeAdapter.register((GsonBuilder)new GsonBuilder()).create();
        ArrayList events = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            events.add(new StreamEvent((Map)ImmutableMap.of((Object)("k" + i), (Object)("v" + i)), Charsets.UTF_8.encode("Msg " + i), (long)i));
        }
        List decoded = (List)gson.fromJson(gson.toJson((Object)events), new TypeToken<List<StreamEvent>>(){}.getType());
        Iterator it1 = events.iterator();
        Iterator it2 = decoded.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Assert.assertTrue((boolean)STREAM_EVENT_EQUIVALENCE.equivalent(it1.next(), it2.next()));
        }
        Assert.assertEquals((Object)it1.hasNext(), (Object)it2.hasNext());
    }
}

