/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.streamevent;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.SchemaHash;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.common.io.BinaryDecoder;
import co.cask.cdap.common.stream.StreamEventCodec;
import co.cask.cdap.internal.io.ReflectionDatumReader;
import co.cask.cdap.internal.io.ReflectionSchemaGenerator;
import co.cask.common.io.ByteBufferInputStream;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class StreamEventCodecTest {
    @Test
    public void testEncodeDecode() {
        StreamEvent event = new StreamEvent((Map)Maps.newHashMap(), ByteBuffer.wrap("Event string".getBytes(Charsets.UTF_8)));
        StreamEventCodec codec = new StreamEventCodec();
        StreamEvent decodedEvent = codec.decodePayload(codec.encodePayload(event));
        Assert.assertEquals((Object)event.getHeaders(), (Object)decodedEvent.getHeaders());
        Assert.assertEquals((Object)event.getBody(), (Object)decodedEvent.getBody());
    }

    @Test
    public void testEncodeDecodeWithDatumDecoder() throws UnsupportedTypeException, IOException {
        StreamEvent event = new StreamEvent((Map)Maps.newHashMap(), ByteBuffer.wrap("Event string".getBytes(Charsets.UTF_8)));
        StreamEventCodec codec = new StreamEventCodec();
        ByteBuffer payload = ByteBuffer.wrap(codec.encodePayload(event));
        SchemaHash schemaHash = new SchemaHash(payload);
        Schema schema = new ReflectionSchemaGenerator().generate(StreamEvent.class);
        Assert.assertEquals((Object)schema.getSchemaHash(), (Object)schemaHash);
        StreamEvent decoded = (StreamEvent)new ReflectionDatumReader(schema, TypeToken.of(StreamEvent.class)).read((Object)new BinaryDecoder((InputStream)new ByteBufferInputStream(payload)), schema);
        Assert.assertEquals((Object)event.getHeaders(), (Object)decoded.getHeaders());
        Assert.assertEquals((Object)event.getBody(), (Object)decoded.getBody());
    }
}

