/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.service;

import co.cask.cdap.common.service.CommandPortService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandPortServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(CommandPortServiceTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandPortServer() throws Exception {
        IncrementCommandHandler handler = new IncrementCommandHandler();
        CommandPortService server = CommandPortService.builder((String)"test").addCommandHandler("increment", "Increments a counter", (CommandPortService.CommandHandler)handler).build();
        final CountDownLatch stopLatch = new CountDownLatch(1);
        Futures.addCallback((ListenableFuture)server.start(), (FutureCallback)new FutureCallback<Service.State>(){

            public void onSuccess(Service.State result) {
                stopLatch.countDown();
            }

            public void onFailure(Throwable t) {
                stopLatch.countDown();
            }
        });
        TimeUnit.SECONDS.sleep(1L);
        try {
            for (int i = 0; i < 10; ++i) {
                Socket clientSocket = new Socket("localhost", server.getPort());
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream(), "UTF-8"));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), "UTF-8"));
                    writer.write("increment");
                    writer.newLine();
                    writer.flush();
                    String response = reader.readLine();
                    Assert.assertEquals((long)(i + 1), (long)Integer.parseInt(response));
                    continue;
                }
                finally {
                    clientSocket.close();
                }
            }
        }
        finally {
            server.stopAndWait();
        }
        Assert.assertEquals((long)10L, (long)handler.getCounter());
        Assert.assertTrue((boolean)stopLatch.await(3L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)Service.State.TERMINATED, (Object)server.state());
    }

    private static final class IncrementCommandHandler
    implements CommandPortService.CommandHandler {
        private int counter;

        private IncrementCommandHandler() {
        }

        public int getCounter() {
            return this.counter;
        }

        public void handle(BufferedWriter respondWriter) throws IOException {
            ++this.counter;
            respondWriter.write(String.format("%d", this.counter));
            respondWriter.newLine();
        }
    }
}

