/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.common.conf;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import co.cask.cdap.common.conf.Configuration;
import co.cask.cdap.common.conf.ConfigurationJsonTool;
import co.cask.cdap.common.conf.SConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class ConfigurationJsonToolTest {
    @Test
    public void testDeprecatedKeys() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        final AtomicBoolean logMessageReceived = new AtomicBoolean(false);
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)loggerFactory;
            AppenderBase<ILoggingEvent> appender = new AppenderBase<ILoggingEvent>(){

                protected void append(ILoggingEvent eventObject) {
                    logMessageReceived.set(true);
                }
            };
            loggerContext.getLogger(Configuration.class).addAppender((Appender)appender);
            appender.setContext((Context)loggerContext);
            appender.start();
        }
        StringBuilder builder = new StringBuilder();
        ConfigurationJsonTool.exportToJson((Configuration)SConfiguration.create(), (Appendable)builder);
        String address = ((JsonObject)new Gson().fromJson(builder.toString(), JsonObject.class)).get("security.auth.server.bind.address").getAsString();
        Assert.assertEquals((Object)"0.0.0.0", (Object)address);
        Assert.assertFalse((boolean)logMessageReceived.get());
        SConfiguration.create().get("security.auth.server.bind.address");
        Assert.assertTrue((boolean)logMessageReceived.get());
    }
}

