/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.rules.ExternalResource;

public class SingletonExternalResource
extends ExternalResource {
    private static final AtomicInteger INSTANCES = new AtomicInteger(0);
    private final ExternalResource externalResource;

    public SingletonExternalResource(ExternalResource externalResource) {
        this.externalResource = externalResource;
    }

    protected void before() throws Throwable {
        if (INSTANCES.getAndIncrement() == 0) {
            Method before = ExternalResource.class.getDeclaredMethod("before", new Class[0]);
            before.setAccessible(true);
            try {
                before.invoke((Object)this.externalResource, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    protected void after() {
        if (INSTANCES.decrementAndGet() == 0) {
            try {
                Method after = ExternalResource.class.getDeclaredMethod("after", new Class[0]);
                after.setAccessible(true);
                after.invoke((Object)this.externalResource, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T extends ExternalResource> T get() {
        Objects.requireNonNull(this.externalResource);
        return (T)this.externalResource;
    }
}

