/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.workflow.WorkflowToken;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.DatasetSpecificationSummary;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.WorkflowNodeStateDetail;
import co.cask.cdap.proto.WorkflowTokenDetail;
import co.cask.cdap.proto.WorkflowTokenNodeDetail;
import co.cask.cdap.proto.codec.WorkflowTokenDetailCodec;
import co.cask.cdap.proto.codec.WorkflowTokenNodeDetailCodec;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.ProgramRunId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nullable;

public class WorkflowClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WorkflowTokenDetail.class, (Object)new WorkflowTokenDetailCodec()).registerTypeAdapter(WorkflowTokenNodeDetail.class, (Object)new WorkflowTokenNodeDetailCodec()).create();
    private final ClientConfig config;
    private final RESTClient restClient;

    @Inject
    public WorkflowClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    WorkflowClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    @Deprecated
    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId.toEntityId());
    }

    public WorkflowTokenDetail getWorkflowToken(ProgramRunId workflowRunId) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId, null, null);
    }

    @Deprecated
    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId, WorkflowToken.Scope scope) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId.toEntityId(), scope);
    }

    public WorkflowTokenDetail getWorkflowToken(ProgramRunId workflowRunId, WorkflowToken.Scope scope) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId, scope, null);
    }

    @Deprecated
    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId, String key) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId.toEntityId(), key);
    }

    public WorkflowTokenDetail getWorkflowToken(ProgramRunId workflowRunId, String key) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId, null, key);
    }

    @Deprecated
    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId, @Nullable WorkflowToken.Scope scope, @Nullable String key) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getWorkflowToken(workflowRunId.toEntityId(), scope, key);
    }

    public WorkflowTokenDetail getWorkflowToken(ProgramRunId workflowRunId, @Nullable WorkflowToken.Scope scope, @Nullable String key) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/workflows/%s/runs/%s/token", workflowRunId.getApplication(), workflowRunId.getProgram(), workflowRunId.getRun());
        URL url = this.config.resolveNamespacedURLV3(workflowRunId.getNamespaceId(), this.appendScopeAndKeyToUrl(path, scope, key));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            String msg = "Either the workflow or its run id";
            if (key != null) {
                msg = String.format("%s or the specified key at the specified scope", msg);
            }
            throw new NotFoundException((Object)workflowRunId, msg);
        }
        return (WorkflowTokenDetail)ObjectResponse.fromJsonBody((HttpResponse)response, WorkflowTokenDetail.class, (Gson)GSON).getResponseObject();
    }

    @Deprecated
    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId.toEntityId(), nodeName);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(ProgramRunId workflowRunId, String nodeName) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId, nodeName, null, null);
    }

    @Deprecated
    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName, WorkflowToken.Scope scope) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId.toEntityId(), nodeName, scope);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(ProgramRunId workflowRunId, String nodeName, WorkflowToken.Scope scope) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId, nodeName, scope, null);
    }

    @Deprecated
    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName, String key) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId.toEntityId(), nodeName, key);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(ProgramRunId workflowRunId, String nodeName, String key) throws UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId, nodeName, null, key);
    }

    @Deprecated
    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName, @Nullable WorkflowToken.Scope scope, @Nullable String key) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getWorkflowTokenAtNode(workflowRunId.toEntityId(), nodeName, scope, key);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(ProgramRunId workflowRunId, String nodeName, @Nullable WorkflowToken.Scope scope, @Nullable String key) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/workflows/%s/runs/%s/nodes/%s/token", workflowRunId.getApplication(), workflowRunId.getProgram(), workflowRunId.getRun(), nodeName);
        URL url = this.config.resolveNamespacedURLV3(workflowRunId.getNamespaceId(), this.appendScopeAndKeyToUrl(path, scope, key));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            String msg = "Either the workflow or its run id";
            if (key != null) {
                msg = String.format("%s or the specified key at the specified scope", msg);
            }
            throw new NotFoundException((Object)workflowRunId, msg);
        }
        return (WorkflowTokenNodeDetail)ObjectResponse.fromJsonBody((HttpResponse)response, WorkflowTokenNodeDetail.class, (Gson)GSON).getResponseObject();
    }

    private String appendScopeAndKeyToUrl(String workflowTokenUrl, @Nullable WorkflowToken.Scope scope, String key) {
        StringBuilder output = new StringBuilder(workflowTokenUrl);
        if (scope != null) {
            output.append(String.format("?scope=%s", scope.name()));
            if (key != null) {
                output.append(String.format("&key=%s", key));
            }
        } else if (key != null) {
            output.append(String.format("?key=%s", key));
        }
        return output.toString();
    }

    public Map<String, DatasetSpecificationSummary> getWorkflowLocalDatasets(ProgramRunId workflowRunId) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.getWorkflowLocalDatasetURL(workflowRunId), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)workflowRunId);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, DatasetSpecificationSummary>>(){}).getResponseObject();
    }

    public void deleteWorkflowLocalDatasets(ProgramRunId workflowRunId) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, this.getWorkflowLocalDatasetURL(workflowRunId), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)workflowRunId);
        }
    }

    private URL getWorkflowLocalDatasetURL(ProgramRunId workflowRunId) throws MalformedURLException {
        String path = String.format("apps/%s/workflows/%s/runs/%s/localdatasets", workflowRunId.getApplication(), workflowRunId.getProgram(), workflowRunId.getRun());
        NamespaceId namespaceId = workflowRunId.getNamespaceId();
        return this.config.resolveNamespacedURLV3(namespaceId, path);
    }

    public Map<String, WorkflowNodeStateDetail> getWorkflowNodeStates(ProgramRunId workflowRunId) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/workflows/%s/runs/%s/nodes/state", workflowRunId.getApplication(), workflowRunId.getProgram(), workflowRunId.getRun());
        NamespaceId namespaceId = workflowRunId.getNamespaceId();
        URL urlPath = this.config.resolveNamespacedURLV3(namespaceId, path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, urlPath, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)workflowRunId);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, WorkflowNodeStateDetail>>(){}).getResponseObject();
    }
}

