/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.StreamNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.stream.StreamEventTypeAdapter;
import co.cask.cdap.common.utils.TimeMathParser;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.StreamDetail;
import co.cask.cdap.proto.StreamProperties;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.StreamId;
import co.cask.cdap.security.authentication.client.AccessToken;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpRequests;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;

@Beta
public class StreamClient {
    private static final Gson GSON = StreamEventTypeAdapter.register((GsonBuilder)new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter())).create();
    private static final TypeToken<List<StreamDetail>> STREAM_DETAIL_LIST_TYPE = new TypeToken<List<StreamDetail>>(){};
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public StreamClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public StreamClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    @Deprecated
    public StreamProperties getConfig(Id.Stream stream) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getConfig(stream.toEntityId());
    }

    public StreamProperties getConfig(StreamId stream) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s", stream.getStream()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
        return (StreamProperties)GSON.fromJson(response.getResponseBodyAsString(Charsets.UTF_8), StreamProperties.class);
    }

    @Deprecated
    public void setStreamProperties(Id.Stream stream, StreamProperties properties) throws IOException, UnauthenticatedException, BadRequestException, StreamNotFoundException, UnauthorizedException {
        this.setStreamProperties(stream.toEntityId(), properties);
    }

    public void setStreamProperties(StreamId stream, StreamProperties properties) throws IOException, UnauthenticatedException, BadRequestException, StreamNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s/properties", stream.getStream()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException("Bad request: " + response.getResponseBodyAsString());
        }
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    @Deprecated
    public void create(Id.Stream newStreamId) throws IOException, BadRequestException, UnauthenticatedException, UnauthorizedException {
        this.create(newStreamId.toEntityId());
    }

    public void create(StreamId newStreamId) throws IOException, BadRequestException, UnauthenticatedException, UnauthorizedException {
        this.create(newStreamId, null);
    }

    @Deprecated
    public void create(Id.Stream newStreamId, @Nullable StreamProperties properties) throws IOException, BadRequestException, UnauthenticatedException, UnauthorizedException {
        this.create(newStreamId.toEntityId(), properties);
    }

    public void create(StreamId newStreamId, @Nullable StreamProperties properties) throws IOException, BadRequestException, UnauthenticatedException, UnauthorizedException {
        HttpResponse response;
        URL url = this.config.resolveNamespacedURLV3(newStreamId.getParent(), String.format("streams/%s", newStreamId.getStream()));
        HttpRequest.Builder builder = HttpRequest.put((URL)url);
        if (properties != null) {
            builder = builder.withBody(GSON.toJson((Object)properties));
        }
        if ((response = this.restClient.execute(builder.build(), this.config.getAccessToken(), 400)).getResponseCode() == 400) {
            throw new BadRequestException("Bad request: " + response.getResponseBodyAsString());
        }
    }

    @Deprecated
    public void setDescription(Id.Stream stream, String description) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.setDescription(stream.toEntityId(), description);
    }

    public void setDescription(StreamId stream, String description) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s/properties", stream.getStream()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)ImmutableMap.of((Object)"description", (Object)description))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    @Deprecated
    public void sendEvent(Id.Stream stream, String event) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.sendEvent(stream.toEntityId(), event);
    }

    public void sendEvent(StreamId stream, String event) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s", stream.getStream()));
        this.writeEvent(url, stream, event);
    }

    @Deprecated
    public void asyncSendEvent(Id.Stream stream, String event) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.asyncSendEvent(stream.toEntityId(), event);
    }

    public void asyncSendEvent(StreamId stream, String event) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s/async", stream.getStream()));
        this.writeEvent(url, stream, event);
    }

    @Deprecated
    public void sendFile(Id.Stream stream, String contentType, File file) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.sendFile(stream.toEntityId(), contentType, file);
    }

    public void sendFile(StreamId stream, String contentType, File file) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.sendBatch(stream, contentType, (InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)file));
    }

    @Deprecated
    public void sendBatch(Id.Stream stream, String contentType, InputSupplier<? extends InputStream> inputSupplier) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.sendBatch(stream.toEntityId(), contentType, inputSupplier);
    }

    public void sendBatch(StreamId stream, String contentType, InputSupplier<? extends InputStream> inputSupplier) throws IOException, StreamNotFoundException, UnauthenticatedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s/batch", stream.getStream()));
        ImmutableMap headers = ImmutableMap.of((Object)"Content-type", (Object)contentType);
        HttpRequest request = HttpRequest.post((URL)url).addHeaders((Map)headers).withBody(inputSupplier).build();
        HttpResponse response = this.restClient.upload(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    @Deprecated
    public void truncate(Id.Stream stream) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.truncate(stream.toEntityId());
    }

    public void truncate(StreamId stream) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s/truncate", stream.getStream()));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    @Deprecated
    public void delete(Id.Stream stream) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.delete(stream.toEntityId());
    }

    public void delete(StreamId stream) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s", stream.getStream()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    @Deprecated
    public void setTTL(Id.Stream stream, long ttlInSeconds) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.setTTL(stream.toEntityId(), ttlInSeconds);
    }

    public void setTTL(StreamId stream, long ttlInSeconds) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getParent(), String.format("streams/%s/properties", stream.getStream()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)ImmutableMap.of((Object)"ttl", (Object)ttlInSeconds))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    @Deprecated
    public List<StreamDetail> list(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.list(namespace.toEntityId());
    }

    public List<StreamDetail> list(NamespaceId namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "streams");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, STREAM_DETAIL_LIST_TYPE).getResponseObject();
    }

    @Deprecated
    public <T extends Collection<? super StreamEvent>> T getEvents(Id.Stream streamId, String startTime, String endTime, int limit, T results) throws IOException, StreamNotFoundException, UnauthenticatedException {
        return this.getEvents(streamId.toEntityId(), startTime, endTime, limit, results);
    }

    public <T extends Collection<? super StreamEvent>> T getEvents(StreamId streamId, String startTime, String endTime, int limit, final T results) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.getEvents(streamId, startTime, endTime, limit, (Function<? super StreamEvent, Boolean>)new Function<StreamEvent, Boolean>(){

            public Boolean apply(StreamEvent input) {
                results.add(input);
                return true;
            }
        });
        return results;
    }

    @Deprecated
    public <T extends Collection<? super StreamEvent>> T getEvents(Id.Stream streamId, long startTime, long endTime, int limit, T results) throws IOException, StreamNotFoundException, UnauthenticatedException {
        return this.getEvents(streamId.toEntityId(), startTime, endTime, limit, results);
    }

    public <T extends Collection<? super StreamEvent>> T getEvents(StreamId streamId, long startTime, long endTime, int limit, T results) throws IOException, StreamNotFoundException, UnauthenticatedException {
        return this.getEvents(streamId, String.valueOf(startTime), String.valueOf(endTime), limit, results);
    }

    @Deprecated
    public void getEvents(Id.Stream streamId, long startTime, long endTime, int limit, Function<? super StreamEvent, Boolean> callback) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.getEvents(streamId.toEntityId(), startTime, endTime, limit, callback);
    }

    public void getEvents(StreamId streamId, long startTime, long endTime, int limit, Function<? super StreamEvent, Boolean> callback) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.getEvents(streamId, String.valueOf(startTime), String.valueOf(endTime), limit, callback);
    }

    @Deprecated
    public void getEvents(Id.Stream streamId, String start, String end, int limit, Function<? super StreamEvent, Boolean> callback) throws IOException, StreamNotFoundException, UnauthenticatedException {
        this.getEvents(streamId.toEntityId(), start, end, limit, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEvents(StreamId streamId, String start, String end, int limit, Function<? super StreamEvent, Boolean> callback) throws IOException, StreamNotFoundException, UnauthenticatedException {
        long startTime = TimeMathParser.parseTime((String)start, (TimeUnit)TimeUnit.MILLISECONDS);
        long endTime = TimeMathParser.parseTime((String)end, (TimeUnit)TimeUnit.MILLISECONDS);
        URL url = this.config.resolveNamespacedURLV3(streamId.getParent(), String.format("streams/%s/events?start=%d&end=%d&limit=%d", streamId.getStream(), startTime, endTime, limit));
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        AccessToken accessToken = this.config.getAccessToken();
        if (accessToken != null) {
            urlConn.setRequestProperty("Authorization", accessToken.getTokenType() + " " + accessToken.getValue());
        }
        if (urlConn instanceof HttpsURLConnection && !this.config.isVerifySSLCert()) {
            try {
                HttpRequests.disableCertCheck((HttpsURLConnection)((HttpsURLConnection)urlConn));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Boolean result;
            if (urlConn.getResponseCode() == 401) {
                throw new UnauthenticatedException("Unauthorized status code received from the server.");
            }
            if (urlConn.getResponseCode() == 404) {
                throw new StreamNotFoundException(streamId);
            }
            if (urlConn.getResponseCode() == 204) {
                return;
            }
            InputStream inputStream = urlConn.getInputStream();
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, Charsets.UTF_8));
            jsonReader.beginArray();
            while (jsonReader.peek() != JsonToken.END_ARRAY && (result = (Boolean)callback.apply(GSON.fromJson(jsonReader, StreamEvent.class))) != null && result.booleanValue()) {
            }
            this.drain(inputStream);
        }
        finally {
            urlConn.disconnect();
        }
    }

    private void writeEvent(URL url, StreamId stream, String event) throws IOException, StreamNotFoundException, UnauthenticatedException, UnauthorizedException {
        HttpRequest request = HttpRequest.post((URL)url).withBody(event).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new StreamNotFoundException(stream);
        }
    }

    private void drain(InputStream input) throws IOException {
        while (input.skip(Long.MAX_VALUE) > 0L) {
        }
    }
}

